package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTypeRequest(apiId: String, typeName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeleteTypeRequest = {
    import DeleteTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeleteTypeRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .typeName(ResourceName.unwrap(typeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeleteTypeRequest.ReadOnly =
    zio.aws.appsync.model.DeleteTypeRequest.wrap(buildAwsValue())
}
object DeleteTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeleteTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeleteTypeRequest =
      zio.aws.appsync.model.DeleteTypeRequest(apiId, typeName)
    def apiId: String
    def typeName: ResourceName
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTypeName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(typeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeleteTypeRequest
  ) extends zio.aws.appsync.model.DeleteTypeRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val typeName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.typeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeleteTypeRequest
  ): zio.aws.appsync.model.DeleteTypeRequest.ReadOnly = new Wrapper(impl)
}
