package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogConfig(
    fieldLogLevel: zio.aws.appsync.model.FieldLogLevel,
    cloudWatchLogsRoleArn: String,
    excludeVerboseContent: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.LogConfig = {
    import LogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.LogConfig
      .builder()
      .fieldLogLevel(fieldLogLevel.unwrap)
      .cloudWatchLogsRoleArn(cloudWatchLogsRoleArn: java.lang.String)
      .optionallyWith(
        excludeVerboseContent.map(value => value: java.lang.Boolean)
      )(_.excludeVerboseContent)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.LogConfig.ReadOnly =
    zio.aws.appsync.model.LogConfig.wrap(buildAwsValue())
}
object LogConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appsync.model.LogConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.LogConfig =
      zio.aws.appsync.model.LogConfig(
        fieldLogLevel,
        cloudWatchLogsRoleArn,
        excludeVerboseContent.map(value => value)
      )
    def fieldLogLevel: zio.aws.appsync.model.FieldLogLevel
    def cloudWatchLogsRoleArn: String
    def excludeVerboseContent: Optional[Boolean]
    def getFieldLogLevel
        : ZIO[Any, Nothing, zio.aws.appsync.model.FieldLogLevel] =
      ZIO.succeed(fieldLogLevel)
    def getCloudWatchLogsRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(cloudWatchLogsRoleArn)
    def getExcludeVerboseContent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("excludeVerboseContent", excludeVerboseContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.LogConfig
  ) extends zio.aws.appsync.model.LogConfig.ReadOnly {
    override val fieldLogLevel: zio.aws.appsync.model.FieldLogLevel =
      zio.aws.appsync.model.FieldLogLevel.wrap(impl.fieldLogLevel())
    override val cloudWatchLogsRoleArn: String =
      impl.cloudWatchLogsRoleArn(): String
    override val excludeVerboseContent: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeVerboseContent())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.LogConfig
  ): zio.aws.appsync.model.LogConfig.ReadOnly = new Wrapper(impl)
}
