package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateMergedGraphqlApiRequest(
    sourceApiIdentifier: String,
    associationId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest = {
    import DisassociateMergedGraphqlApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest
      .builder()
      .sourceApiIdentifier(sourceApiIdentifier: java.lang.String)
      .associationId(associationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.DisassociateMergedGraphqlApiRequest.ReadOnly =
    zio.aws.appsync.model.DisassociateMergedGraphqlApiRequest
      .wrap(buildAwsValue())
}
object DisassociateMergedGraphqlApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DisassociateMergedGraphqlApiRequest =
      zio.aws.appsync.model
        .DisassociateMergedGraphqlApiRequest(sourceApiIdentifier, associationId)
    def sourceApiIdentifier: String
    def associationId: String
    def getSourceApiIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceApiIdentifier)
    def getAssociationId: ZIO[Any, Nothing, String] = ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest
  ) extends zio.aws.appsync.model.DisassociateMergedGraphqlApiRequest.ReadOnly {
    override val sourceApiIdentifier: String =
      impl.sourceApiIdentifier(): String
    override val associationId: String = impl.associationId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest
  ): zio.aws.appsync.model.DisassociateMergedGraphqlApiRequest.ReadOnly =
    new Wrapper(impl)
}
