package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.{MaxResults, PaginationToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGraphqlApisRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    apiType: Optional[zio.aws.appsync.model.GraphQLApiType] = Optional.Absent,
    owner: Optional[zio.aws.appsync.model.Ownership] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest = {
    import ListGraphqlApisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(apiType.map(value => value.unwrap))(_.apiType)
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListGraphqlApisRequest.ReadOnly =
    zio.aws.appsync.model.ListGraphqlApisRequest.wrap(buildAwsValue())
}
object ListGraphqlApisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListGraphqlApisRequest =
      zio.aws.appsync.model.ListGraphqlApisRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        apiType.map(value => value),
        owner.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def apiType: Optional[zio.aws.appsync.model.GraphQLApiType]
    def owner: Optional[zio.aws.appsync.model.Ownership]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getApiType: ZIO[Any, AwsError, zio.aws.appsync.model.GraphQLApiType] =
      AwsError.unwrapOptionField("apiType", apiType)
    def getOwner: ZIO[Any, AwsError, zio.aws.appsync.model.Ownership] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest
  ) extends zio.aws.appsync.model.ListGraphqlApisRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appsync.model.primitives.MaxResults(value))
    override val apiType: Optional[zio.aws.appsync.model.GraphQLApiType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiType())
        .map(value => zio.aws.appsync.model.GraphQLApiType.wrap(value))
    override val owner: Optional[zio.aws.appsync.model.Ownership] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.appsync.model.Ownership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest
  ): zio.aws.appsync.model.ListGraphqlApisRequest.ReadOnly = new Wrapper(impl)
}
