package zio.aws.appsync
import zio.prelude.Subtype
import zio.aws.appsync.model.primitives.{TagValue, TagKey}
import zio.Chunk
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.appsync.model.primitives.Blob.Type
    type BooleanValue = Boolean
    object CertificateArn extends Subtype[String]
    type CertificateArn = zio.aws.appsync.model.primitives.CertificateArn.Type
    object Code extends Subtype[String]
    type Code = zio.aws.appsync.model.primitives.Code.Type
    object CodeErrorColumn extends Subtype[Int]
    type CodeErrorColumn = zio.aws.appsync.model.primitives.CodeErrorColumn.Type
    object CodeErrorLine extends Subtype[Int]
    type CodeErrorLine = zio.aws.appsync.model.primitives.CodeErrorLine.Type
    object CodeErrorSpan extends Subtype[Int]
    type CodeErrorSpan = zio.aws.appsync.model.primitives.CodeErrorSpan.Type
    object Context extends Subtype[String]
    type Context = zio.aws.appsync.model.primitives.Context.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.appsync.model.primitives.Date.Type
    object Description extends Subtype[String]
    type Description = zio.aws.appsync.model.primitives.Description.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.appsync.model.primitives.DomainName.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.appsync.model.primitives.ErrorMessage.Type
    object EvaluationResult extends Subtype[String]
    type EvaluationResult =
      zio.aws.appsync.model.primitives.EvaluationResult.Type
    object MappingTemplate extends Subtype[String]
    type MappingTemplate = zio.aws.appsync.model.primitives.MappingTemplate.Type
    object MaxBatchSize extends Subtype[Int]
    type MaxBatchSize = zio.aws.appsync.model.primitives.MaxBatchSize.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.appsync.model.primitives.MaxResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken = zio.aws.appsync.model.primitives.PaginationToken.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.appsync.model.primitives.ResourceArn.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.appsync.model.primitives.ResourceName.Type
    object TTL extends Subtype[Int]
    type TTL = zio.aws.appsync.model.primitives.TTL.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.appsync.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.appsync.model.primitives.TagValue.Type
    object Template extends Subtype[String]
    type Template = zio.aws.appsync.model.primitives.Template.Type
  }
  type AdditionalAuthenticationProviders =
    List[zio.aws.appsync.model.AdditionalAuthenticationProvider]
  type ApiKeys = List[zio.aws.appsync.model.ApiKey]
  type CachingKeys = List[String]
  type CodeErrors = List[zio.aws.appsync.model.CodeError]
  type DataSources = List[zio.aws.appsync.model.DataSource]
  type DomainNameConfigs = List[zio.aws.appsync.model.DomainNameConfig]
  type Functions = List[zio.aws.appsync.model.FunctionConfiguration]
  type FunctionsIds = List[String]
  type GraphqlApis = List[zio.aws.appsync.model.GraphqlApi]
  type Logs = List[String]
  type MapOfStringToString = Map[String, String]
  type Resolvers = List[zio.aws.appsync.model.Resolver]
  type SourceApiAssociationSummaryList =
    List[zio.aws.appsync.model.SourceApiAssociationSummary]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TypeList = List[zio.aws.appsync.model.Type]
}
