package zio.aws.appsync
import zio.aws.appsync.model.CreateDomainNameResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.appsync.model.{
  UpdateResolverRequest,
  DeleteTypeResponse,
  ListTypesByAssociationResponse,
  UpdateTypeRequest,
  ListTypesResponse,
  EvaluateCodeResponse,
  DisassociateApiRequest,
  ListTypesByAssociationRequest,
  DeleteApiKeyRequest,
  EvaluateCodeRequest,
  ListApiKeysResponse,
  AssociateApiRequest,
  DeleteTypeRequest,
  DisassociateApiResponse,
  CreateGraphqlApiRequest,
  CreateApiKeyRequest,
  UpdateDataSourceRequest,
  UpdateGraphqlApiResponse,
  DisassociateSourceGraphqlApiResponse,
  ListResolversByFunctionResponse,
  GetGraphqlApiRequest,
  GetFunctionRequest,
  DeleteGraphqlApiRequest,
  DeleteApiCacheRequest,
  CreateResolverResponse,
  DeleteFunctionRequest,
  DeleteDataSourceResponse,
  FlushApiCacheResponse,
  UpdateApiCacheResponse,
  GetSchemaCreationStatusResponse,
  ListGraphqlApisRequest,
  GetTypeRequest,
  DeleteApiCacheResponse,
  GetDataSourceResponse,
  GetResolverRequest,
  CreateApiCacheResponse,
  ListTagsForResourceRequest,
  DeleteResolverResponse,
  FlushApiCacheRequest,
  AssociateSourceGraphqlApiRequest,
  CreateDataSourceRequest,
  UpdateApiKeyResponse,
  ListFunctionsResponse,
  GetApiCacheRequest,
  CreateTypeRequest,
  ListSourceApiAssociationsRequest,
  CreateDomainNameResponse,
  CreateDataSourceResponse,
  ListResolversByFunctionRequest,
  ListTypesRequest,
  GetApiAssociationResponse,
  StartSchemaMergeResponse,
  ListGraphqlApisResponse,
  GetTypeResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetDataSourceRequest,
  ListDomainNamesRequest,
  GetFunctionResponse,
  GetApiAssociationRequest,
  GetGraphqlApiResponse,
  CreateResolverRequest,
  StartSchemaCreationRequest,
  UpdateDomainNameResponse,
  UpdateApiCacheRequest,
  DeleteDomainNameRequest,
  ListSourceApiAssociationsResponse,
  DeleteDomainNameResponse,
  UpdateDomainNameRequest,
  CreateDomainNameRequest,
  UpdateDataSourceResponse,
  ListDataSourcesRequest,
  GetSourceApiAssociationResponse,
  CreateFunctionRequest,
  UpdateFunctionResponse,
  DeleteDataSourceRequest,
  GetApiCacheResponse,
  AssociateApiResponse,
  CreateFunctionResponse,
  ListFunctionsRequest,
  UntagResourceRequest,
  CreateTypeResponse,
  DisassociateMergedGraphqlApiResponse,
  UpdateSourceApiAssociationResponse,
  GetIntrospectionSchemaRequest,
  EvaluateMappingTemplateResponse,
  GetResolverResponse,
  CreateApiCacheRequest,
  GetSchemaCreationStatusRequest,
  DisassociateMergedGraphqlApiRequest,
  ListResolversResponse,
  UpdateFunctionRequest,
  ListDataSourcesResponse,
  DeleteApiKeyResponse,
  CreateGraphqlApiResponse,
  GetDomainNameResponse,
  EvaluateMappingTemplateRequest,
  ListResolversRequest,
  AssociateSourceGraphqlApiResponse,
  GetIntrospectionSchemaResponse,
  UpdateResolverResponse,
  UpdateTypeResponse,
  AssociateMergedGraphqlApiResponse,
  StartSchemaCreationResponse,
  DisassociateSourceGraphqlApiRequest,
  DeleteFunctionResponse,
  GetDomainNameRequest,
  TagResourceResponse,
  ListApiKeysRequest,
  GetSourceApiAssociationRequest,
  DeleteResolverRequest,
  CreateApiKeyResponse,
  StartSchemaMergeRequest,
  UpdateGraphqlApiRequest,
  ListDomainNamesResponse,
  TagResourceRequest,
  AssociateMergedGraphqlApiRequest,
  UpdateSourceApiAssociationRequest,
  DeleteGraphqlApiResponse,
  UpdateApiKeyRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.appsync.{
  AppSyncAsyncClientBuilder,
  AppSyncAsyncClient
}
import scala.jdk.CollectionConverters._
trait AppSync extends AspectSupport[AppSync] {
  val api: AppSyncAsyncClient
  def listTypes(
      request: zio.aws.appsync.model.ListTypesRequest
  ): IO[AwsError, zio.aws.appsync.model.ListTypesResponse.ReadOnly]
  def updateType(
      request: zio.aws.appsync.model.UpdateTypeRequest
  ): IO[AwsError, zio.aws.appsync.model.UpdateTypeResponse.ReadOnly]
  def getDataSource(
      request: zio.aws.appsync.model.GetDataSourceRequest
  ): IO[AwsError, zio.aws.appsync.model.GetDataSourceResponse.ReadOnly]
  def getApiCache(
      request: zio.aws.appsync.model.GetApiCacheRequest
  ): IO[AwsError, zio.aws.appsync.model.GetApiCacheResponse.ReadOnly]
  def getSourceApiAssociation(
      request: zio.aws.appsync.model.GetSourceApiAssociationRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.GetSourceApiAssociationResponse.ReadOnly
  ]
  def updateSourceApiAssociation(
      request: zio.aws.appsync.model.UpdateSourceApiAssociationRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.UpdateSourceApiAssociationResponse.ReadOnly
  ]
  def associateMergedGraphqlApi(
      request: zio.aws.appsync.model.AssociateMergedGraphqlApiRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.AssociateMergedGraphqlApiResponse.ReadOnly
  ]
  def createApiCache(
      request: zio.aws.appsync.model.CreateApiCacheRequest
  ): IO[AwsError, zio.aws.appsync.model.CreateApiCacheResponse.ReadOnly]
  def updateApiKey(
      request: zio.aws.appsync.model.UpdateApiKeyRequest
  ): IO[AwsError, zio.aws.appsync.model.UpdateApiKeyResponse.ReadOnly]
  def listTypesByAssociation(
      request: zio.aws.appsync.model.ListTypesByAssociationRequest
  ): IO[AwsError, zio.aws.appsync.model.ListTypesByAssociationResponse.ReadOnly]
  def getIntrospectionSchema(
      request: zio.aws.appsync.model.GetIntrospectionSchemaRequest
  ): IO[AwsError, zio.aws.appsync.model.GetIntrospectionSchemaResponse.ReadOnly]
  def flushApiCache(
      request: zio.aws.appsync.model.FlushApiCacheRequest
  ): IO[AwsError, zio.aws.appsync.model.FlushApiCacheResponse.ReadOnly]
  def associateSourceGraphqlApi(
      request: zio.aws.appsync.model.AssociateSourceGraphqlApiRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.AssociateSourceGraphqlApiResponse.ReadOnly
  ]
  def updateApiCache(
      request: zio.aws.appsync.model.UpdateApiCacheRequest
  ): IO[AwsError, zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly]
  def createDataSource(
      request: zio.aws.appsync.model.CreateDataSourceRequest
  ): IO[AwsError, zio.aws.appsync.model.CreateDataSourceResponse.ReadOnly]
  def disassociateApi(
      request: zio.aws.appsync.model.DisassociateApiRequest
  ): IO[AwsError, zio.aws.appsync.model.DisassociateApiResponse.ReadOnly]
  def startSchemaMerge(
      request: zio.aws.appsync.model.StartSchemaMergeRequest
  ): IO[AwsError, zio.aws.appsync.model.StartSchemaMergeResponse.ReadOnly]
  def deleteApiCache(
      request: zio.aws.appsync.model.DeleteApiCacheRequest
  ): IO[AwsError, zio.aws.appsync.model.DeleteApiCacheResponse.ReadOnly]
  def deleteFunction(
      request: zio.aws.appsync.model.DeleteFunctionRequest
  ): IO[AwsError, zio.aws.appsync.model.DeleteFunctionResponse.ReadOnly]
  def evaluateCode(
      request: zio.aws.appsync.model.EvaluateCodeRequest
  ): IO[AwsError, zio.aws.appsync.model.EvaluateCodeResponse.ReadOnly]
  def listDataSources(
      request: zio.aws.appsync.model.ListDataSourcesRequest
  ): IO[AwsError, zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly]
  def createDomainName(
      request: zio.aws.appsync.model.CreateDomainNameRequest
  ): IO[AwsError, ReadOnly]
  def createGraphqlApi(
      request: zio.aws.appsync.model.CreateGraphqlApiRequest
  ): IO[AwsError, zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly]
  def getType(
      request: zio.aws.appsync.model.GetTypeRequest
  ): IO[AwsError, zio.aws.appsync.model.GetTypeResponse.ReadOnly]
  def getResolver(
      request: zio.aws.appsync.model.GetResolverRequest
  ): IO[AwsError, zio.aws.appsync.model.GetResolverResponse.ReadOnly]
  def getSchemaCreationStatus(
      request: zio.aws.appsync.model.GetSchemaCreationStatusRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.GetSchemaCreationStatusResponse.ReadOnly
  ]
  def updateGraphqlApi(
      request: zio.aws.appsync.model.UpdateGraphqlApiRequest
  ): IO[AwsError, zio.aws.appsync.model.UpdateGraphqlApiResponse.ReadOnly]
  def createType(
      request: zio.aws.appsync.model.CreateTypeRequest
  ): IO[AwsError, zio.aws.appsync.model.CreateTypeResponse.ReadOnly]
  def listResolvers(
      request: zio.aws.appsync.model.ListResolversRequest
  ): IO[AwsError, zio.aws.appsync.model.ListResolversResponse.ReadOnly]
  def untagResource(
      request: zio.aws.appsync.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.appsync.model.UntagResourceResponse.ReadOnly]
  def listGraphqlApis(
      request: zio.aws.appsync.model.ListGraphqlApisRequest
  ): IO[AwsError, zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly]
  def updateDataSource(
      request: zio.aws.appsync.model.UpdateDataSourceRequest
  ): IO[AwsError, zio.aws.appsync.model.UpdateDataSourceResponse.ReadOnly]
  def deleteApiKey(
      request: zio.aws.appsync.model.DeleteApiKeyRequest
  ): IO[AwsError, zio.aws.appsync.model.DeleteApiKeyResponse.ReadOnly]
  def updateResolver(
      request: zio.aws.appsync.model.UpdateResolverRequest
  ): IO[AwsError, zio.aws.appsync.model.UpdateResolverResponse.ReadOnly]
  def createApiKey(
      request: zio.aws.appsync.model.CreateApiKeyRequest
  ): IO[AwsError, zio.aws.appsync.model.CreateApiKeyResponse.ReadOnly]
  def updateFunction(
      request: zio.aws.appsync.model.UpdateFunctionRequest
  ): IO[AwsError, zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly]
  def deleteDataSource(
      request: zio.aws.appsync.model.DeleteDataSourceRequest
  ): IO[AwsError, zio.aws.appsync.model.DeleteDataSourceResponse.ReadOnly]
  def listApiKeys(
      request: zio.aws.appsync.model.ListApiKeysRequest
  ): IO[AwsError, zio.aws.appsync.model.ListApiKeysResponse.ReadOnly]
  def deleteResolver(
      request: zio.aws.appsync.model.DeleteResolverRequest
  ): IO[AwsError, zio.aws.appsync.model.DeleteResolverResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.appsync.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.appsync.model.ListTagsForResourceResponse.ReadOnly]
  def deleteGraphqlApi(
      request: zio.aws.appsync.model.DeleteGraphqlApiRequest
  ): IO[AwsError, zio.aws.appsync.model.DeleteGraphqlApiResponse.ReadOnly]
  def tagResource(
      request: zio.aws.appsync.model.TagResourceRequest
  ): IO[AwsError, zio.aws.appsync.model.TagResourceResponse.ReadOnly]
  def listFunctions(
      request: zio.aws.appsync.model.ListFunctionsRequest
  ): IO[AwsError, zio.aws.appsync.model.ListFunctionsResponse.ReadOnly]
  def disassociateMergedGraphqlApi(
      request: zio.aws.appsync.model.DisassociateMergedGraphqlApiRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.DisassociateMergedGraphqlApiResponse.ReadOnly
  ]
  def startSchemaCreation(
      request: zio.aws.appsync.model.StartSchemaCreationRequest
  ): IO[AwsError, zio.aws.appsync.model.StartSchemaCreationResponse.ReadOnly]
  def associateApi(
      request: zio.aws.appsync.model.AssociateApiRequest
  ): IO[AwsError, zio.aws.appsync.model.AssociateApiResponse.ReadOnly]
  def evaluateMappingTemplate(
      request: zio.aws.appsync.model.EvaluateMappingTemplateRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.EvaluateMappingTemplateResponse.ReadOnly
  ]
  def createResolver(
      request: zio.aws.appsync.model.CreateResolverRequest
  ): IO[AwsError, zio.aws.appsync.model.CreateResolverResponse.ReadOnly]
  def deleteType(
      request: zio.aws.appsync.model.DeleteTypeRequest
  ): IO[AwsError, zio.aws.appsync.model.DeleteTypeResponse.ReadOnly]
  def listSourceApiAssociations(
      request: zio.aws.appsync.model.ListSourceApiAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.ListSourceApiAssociationsResponse.ReadOnly
  ]
  def listDomainNames(
      request: zio.aws.appsync.model.ListDomainNamesRequest
  ): IO[AwsError, zio.aws.appsync.model.ListDomainNamesResponse.ReadOnly]
  def getGraphqlApi(
      request: zio.aws.appsync.model.GetGraphqlApiRequest
  ): IO[AwsError, zio.aws.appsync.model.GetGraphqlApiResponse.ReadOnly]
  def getApiAssociation(
      request: zio.aws.appsync.model.GetApiAssociationRequest
  ): IO[AwsError, zio.aws.appsync.model.GetApiAssociationResponse.ReadOnly]
  def disassociateSourceGraphqlApi(
      request: zio.aws.appsync.model.DisassociateSourceGraphqlApiRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse.ReadOnly
  ]
  def createFunction(
      request: zio.aws.appsync.model.CreateFunctionRequest
  ): IO[AwsError, zio.aws.appsync.model.CreateFunctionResponse.ReadOnly]
  def getDomainName(
      request: zio.aws.appsync.model.GetDomainNameRequest
  ): IO[AwsError, zio.aws.appsync.model.GetDomainNameResponse.ReadOnly]
  def deleteDomainName(
      request: zio.aws.appsync.model.DeleteDomainNameRequest
  ): IO[AwsError, zio.aws.appsync.model.DeleteDomainNameResponse.ReadOnly]
  def getFunction(
      request: zio.aws.appsync.model.GetFunctionRequest
  ): IO[AwsError, zio.aws.appsync.model.GetFunctionResponse.ReadOnly]
  def updateDomainName(
      request: zio.aws.appsync.model.UpdateDomainNameRequest
  ): IO[AwsError, zio.aws.appsync.model.UpdateDomainNameResponse.ReadOnly]
  def listResolversByFunction(
      request: zio.aws.appsync.model.ListResolversByFunctionRequest
  ): IO[
    AwsError,
    zio.aws.appsync.model.ListResolversByFunctionResponse.ReadOnly
  ]
}
object AppSync {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AppSync] = customized(
    identity
  )
  def customized(
      customization: AppSyncAsyncClientBuilder => AppSyncAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AppSync] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AppSyncAsyncClientBuilder => AppSyncAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, AppSync] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AppSyncAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[AppSyncAsyncClient, AppSyncAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[AppSyncAsyncClient, AppSyncAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new AppSyncImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AppSyncImpl[R](
      override val api: AppSyncAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AppSync
      with AwsServiceBase[R] {
    override val serviceName: String = "AppSync"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AppSyncImpl[R1] = new AppSyncImpl(api, newAspect, r)
    def listTypes(
        request: zio.aws.appsync.model.ListTypesRequest
    ): IO[AwsError, zio.aws.appsync.model.ListTypesResponse.ReadOnly] =
      asyncRequestResponse[ListTypesRequest, ListTypesResponse](
        "listTypes",
        api.listTypes
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.ListTypesResponse.wrap)
        .provideEnvironment(r)
    def updateType(
        request: zio.aws.appsync.model.UpdateTypeRequest
    ): IO[AwsError, zio.aws.appsync.model.UpdateTypeResponse.ReadOnly] =
      asyncRequestResponse[UpdateTypeRequest, UpdateTypeResponse](
        "updateType",
        api.updateType
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UpdateTypeResponse.wrap)
        .provideEnvironment(r)
    def getDataSource(
        request: zio.aws.appsync.model.GetDataSourceRequest
    ): IO[AwsError, zio.aws.appsync.model.GetDataSourceResponse.ReadOnly] =
      asyncRequestResponse[GetDataSourceRequest, GetDataSourceResponse](
        "getDataSource",
        api.getDataSource
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.GetDataSourceResponse.wrap)
        .provideEnvironment(r)
    def getApiCache(
        request: zio.aws.appsync.model.GetApiCacheRequest
    ): IO[AwsError, zio.aws.appsync.model.GetApiCacheResponse.ReadOnly] =
      asyncRequestResponse[GetApiCacheRequest, GetApiCacheResponse](
        "getApiCache",
        api.getApiCache
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.GetApiCacheResponse.wrap)
        .provideEnvironment(r)
    def getSourceApiAssociation(
        request: zio.aws.appsync.model.GetSourceApiAssociationRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.GetSourceApiAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSourceApiAssociationRequest,
      GetSourceApiAssociationResponse
    ]("getSourceApiAssociation", api.getSourceApiAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.GetSourceApiAssociationResponse.wrap)
      .provideEnvironment(r)
    def updateSourceApiAssociation(
        request: zio.aws.appsync.model.UpdateSourceApiAssociationRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.UpdateSourceApiAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSourceApiAssociationRequest,
      UpdateSourceApiAssociationResponse
    ]("updateSourceApiAssociation", api.updateSourceApiAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.UpdateSourceApiAssociationResponse.wrap)
      .provideEnvironment(r)
    def associateMergedGraphqlApi(
        request: zio.aws.appsync.model.AssociateMergedGraphqlApiRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.AssociateMergedGraphqlApiResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateMergedGraphqlApiRequest,
      AssociateMergedGraphqlApiResponse
    ]("associateMergedGraphqlApi", api.associateMergedGraphqlApi)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.AssociateMergedGraphqlApiResponse.wrap)
      .provideEnvironment(r)
    def createApiCache(
        request: zio.aws.appsync.model.CreateApiCacheRequest
    ): IO[AwsError, zio.aws.appsync.model.CreateApiCacheResponse.ReadOnly] =
      asyncRequestResponse[CreateApiCacheRequest, CreateApiCacheResponse](
        "createApiCache",
        api.createApiCache
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.CreateApiCacheResponse.wrap)
        .provideEnvironment(r)
    def updateApiKey(
        request: zio.aws.appsync.model.UpdateApiKeyRequest
    ): IO[AwsError, zio.aws.appsync.model.UpdateApiKeyResponse.ReadOnly] =
      asyncRequestResponse[UpdateApiKeyRequest, UpdateApiKeyResponse](
        "updateApiKey",
        api.updateApiKey
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UpdateApiKeyResponse.wrap)
        .provideEnvironment(r)
    def listTypesByAssociation(
        request: zio.aws.appsync.model.ListTypesByAssociationRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.ListTypesByAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTypesByAssociationRequest,
      ListTypesByAssociationResponse
    ]("listTypesByAssociation", api.listTypesByAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.ListTypesByAssociationResponse.wrap)
      .provideEnvironment(r)
    def getIntrospectionSchema(
        request: zio.aws.appsync.model.GetIntrospectionSchemaRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.GetIntrospectionSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      GetIntrospectionSchemaRequest,
      GetIntrospectionSchemaResponse
    ]("getIntrospectionSchema", api.getIntrospectionSchema)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.GetIntrospectionSchemaResponse.wrap)
      .provideEnvironment(r)
    def flushApiCache(
        request: zio.aws.appsync.model.FlushApiCacheRequest
    ): IO[AwsError, zio.aws.appsync.model.FlushApiCacheResponse.ReadOnly] =
      asyncRequestResponse[FlushApiCacheRequest, FlushApiCacheResponse](
        "flushApiCache",
        api.flushApiCache
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.FlushApiCacheResponse.wrap)
        .provideEnvironment(r)
    def associateSourceGraphqlApi(
        request: zio.aws.appsync.model.AssociateSourceGraphqlApiRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.AssociateSourceGraphqlApiResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateSourceGraphqlApiRequest,
      AssociateSourceGraphqlApiResponse
    ]("associateSourceGraphqlApi", api.associateSourceGraphqlApi)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.AssociateSourceGraphqlApiResponse.wrap)
      .provideEnvironment(r)
    def updateApiCache(
        request: zio.aws.appsync.model.UpdateApiCacheRequest
    ): IO[AwsError, zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly] =
      asyncRequestResponse[UpdateApiCacheRequest, UpdateApiCacheResponse](
        "updateApiCache",
        api.updateApiCache
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UpdateApiCacheResponse.wrap)
        .provideEnvironment(r)
    def createDataSource(
        request: zio.aws.appsync.model.CreateDataSourceRequest
    ): IO[AwsError, zio.aws.appsync.model.CreateDataSourceResponse.ReadOnly] =
      asyncRequestResponse[CreateDataSourceRequest, CreateDataSourceResponse](
        "createDataSource",
        api.createDataSource
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.CreateDataSourceResponse.wrap)
        .provideEnvironment(r)
    def disassociateApi(
        request: zio.aws.appsync.model.DisassociateApiRequest
    ): IO[AwsError, zio.aws.appsync.model.DisassociateApiResponse.ReadOnly] =
      asyncRequestResponse[DisassociateApiRequest, DisassociateApiResponse](
        "disassociateApi",
        api.disassociateApi
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DisassociateApiResponse.wrap)
        .provideEnvironment(r)
    def startSchemaMerge(
        request: zio.aws.appsync.model.StartSchemaMergeRequest
    ): IO[AwsError, zio.aws.appsync.model.StartSchemaMergeResponse.ReadOnly] =
      asyncRequestResponse[StartSchemaMergeRequest, StartSchemaMergeResponse](
        "startSchemaMerge",
        api.startSchemaMerge
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.StartSchemaMergeResponse.wrap)
        .provideEnvironment(r)
    def deleteApiCache(
        request: zio.aws.appsync.model.DeleteApiCacheRequest
    ): IO[AwsError, zio.aws.appsync.model.DeleteApiCacheResponse.ReadOnly] =
      asyncRequestResponse[DeleteApiCacheRequest, DeleteApiCacheResponse](
        "deleteApiCache",
        api.deleteApiCache
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DeleteApiCacheResponse.wrap)
        .provideEnvironment(r)
    def deleteFunction(
        request: zio.aws.appsync.model.DeleteFunctionRequest
    ): IO[AwsError, zio.aws.appsync.model.DeleteFunctionResponse.ReadOnly] =
      asyncRequestResponse[DeleteFunctionRequest, DeleteFunctionResponse](
        "deleteFunction",
        api.deleteFunction
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DeleteFunctionResponse.wrap)
        .provideEnvironment(r)
    def evaluateCode(
        request: zio.aws.appsync.model.EvaluateCodeRequest
    ): IO[AwsError, zio.aws.appsync.model.EvaluateCodeResponse.ReadOnly] =
      asyncRequestResponse[EvaluateCodeRequest, EvaluateCodeResponse](
        "evaluateCode",
        api.evaluateCode
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.EvaluateCodeResponse.wrap)
        .provideEnvironment(r)
    def listDataSources(
        request: zio.aws.appsync.model.ListDataSourcesRequest
    ): IO[AwsError, zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly] =
      asyncRequestResponse[ListDataSourcesRequest, ListDataSourcesResponse](
        "listDataSources",
        api.listDataSources
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.ListDataSourcesResponse.wrap)
        .provideEnvironment(r)
    def createDomainName(
        request: zio.aws.appsync.model.CreateDomainNameRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateDomainNameRequest, CreateDomainNameResponse](
        "createDomainName",
        api.createDomainName
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.CreateDomainNameResponse.wrap)
        .provideEnvironment(r)
    def createGraphqlApi(
        request: zio.aws.appsync.model.CreateGraphqlApiRequest
    ): IO[AwsError, zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly] =
      asyncRequestResponse[CreateGraphqlApiRequest, CreateGraphqlApiResponse](
        "createGraphqlApi",
        api.createGraphqlApi
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.CreateGraphqlApiResponse.wrap)
        .provideEnvironment(r)
    def getType(
        request: zio.aws.appsync.model.GetTypeRequest
    ): IO[AwsError, zio.aws.appsync.model.GetTypeResponse.ReadOnly] =
      asyncRequestResponse[GetTypeRequest, GetTypeResponse](
        "getType",
        api.getType
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.GetTypeResponse.wrap)
        .provideEnvironment(r)
    def getResolver(
        request: zio.aws.appsync.model.GetResolverRequest
    ): IO[AwsError, zio.aws.appsync.model.GetResolverResponse.ReadOnly] =
      asyncRequestResponse[GetResolverRequest, GetResolverResponse](
        "getResolver",
        api.getResolver
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.GetResolverResponse.wrap)
        .provideEnvironment(r)
    def getSchemaCreationStatus(
        request: zio.aws.appsync.model.GetSchemaCreationStatusRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.GetSchemaCreationStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSchemaCreationStatusRequest,
      GetSchemaCreationStatusResponse
    ]("getSchemaCreationStatus", api.getSchemaCreationStatus)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.GetSchemaCreationStatusResponse.wrap)
      .provideEnvironment(r)
    def updateGraphqlApi(
        request: zio.aws.appsync.model.UpdateGraphqlApiRequest
    ): IO[AwsError, zio.aws.appsync.model.UpdateGraphqlApiResponse.ReadOnly] =
      asyncRequestResponse[UpdateGraphqlApiRequest, UpdateGraphqlApiResponse](
        "updateGraphqlApi",
        api.updateGraphqlApi
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UpdateGraphqlApiResponse.wrap)
        .provideEnvironment(r)
    def createType(
        request: zio.aws.appsync.model.CreateTypeRequest
    ): IO[AwsError, zio.aws.appsync.model.CreateTypeResponse.ReadOnly] =
      asyncRequestResponse[CreateTypeRequest, CreateTypeResponse](
        "createType",
        api.createType
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.CreateTypeResponse.wrap)
        .provideEnvironment(r)
    def listResolvers(
        request: zio.aws.appsync.model.ListResolversRequest
    ): IO[AwsError, zio.aws.appsync.model.ListResolversResponse.ReadOnly] =
      asyncRequestResponse[ListResolversRequest, ListResolversResponse](
        "listResolvers",
        api.listResolvers
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.ListResolversResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.appsync.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.appsync.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listGraphqlApis(
        request: zio.aws.appsync.model.ListGraphqlApisRequest
    ): IO[AwsError, zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly] =
      asyncRequestResponse[ListGraphqlApisRequest, ListGraphqlApisResponse](
        "listGraphqlApis",
        api.listGraphqlApis
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.ListGraphqlApisResponse.wrap)
        .provideEnvironment(r)
    def updateDataSource(
        request: zio.aws.appsync.model.UpdateDataSourceRequest
    ): IO[AwsError, zio.aws.appsync.model.UpdateDataSourceResponse.ReadOnly] =
      asyncRequestResponse[UpdateDataSourceRequest, UpdateDataSourceResponse](
        "updateDataSource",
        api.updateDataSource
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UpdateDataSourceResponse.wrap)
        .provideEnvironment(r)
    def deleteApiKey(
        request: zio.aws.appsync.model.DeleteApiKeyRequest
    ): IO[AwsError, zio.aws.appsync.model.DeleteApiKeyResponse.ReadOnly] =
      asyncRequestResponse[DeleteApiKeyRequest, DeleteApiKeyResponse](
        "deleteApiKey",
        api.deleteApiKey
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DeleteApiKeyResponse.wrap)
        .provideEnvironment(r)
    def updateResolver(
        request: zio.aws.appsync.model.UpdateResolverRequest
    ): IO[AwsError, zio.aws.appsync.model.UpdateResolverResponse.ReadOnly] =
      asyncRequestResponse[UpdateResolverRequest, UpdateResolverResponse](
        "updateResolver",
        api.updateResolver
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UpdateResolverResponse.wrap)
        .provideEnvironment(r)
    def createApiKey(
        request: zio.aws.appsync.model.CreateApiKeyRequest
    ): IO[AwsError, zio.aws.appsync.model.CreateApiKeyResponse.ReadOnly] =
      asyncRequestResponse[CreateApiKeyRequest, CreateApiKeyResponse](
        "createApiKey",
        api.createApiKey
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.CreateApiKeyResponse.wrap)
        .provideEnvironment(r)
    def updateFunction(
        request: zio.aws.appsync.model.UpdateFunctionRequest
    ): IO[AwsError, zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly] =
      asyncRequestResponse[UpdateFunctionRequest, UpdateFunctionResponse](
        "updateFunction",
        api.updateFunction
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UpdateFunctionResponse.wrap)
        .provideEnvironment(r)
    def deleteDataSource(
        request: zio.aws.appsync.model.DeleteDataSourceRequest
    ): IO[AwsError, zio.aws.appsync.model.DeleteDataSourceResponse.ReadOnly] =
      asyncRequestResponse[DeleteDataSourceRequest, DeleteDataSourceResponse](
        "deleteDataSource",
        api.deleteDataSource
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DeleteDataSourceResponse.wrap)
        .provideEnvironment(r)
    def listApiKeys(
        request: zio.aws.appsync.model.ListApiKeysRequest
    ): IO[AwsError, zio.aws.appsync.model.ListApiKeysResponse.ReadOnly] =
      asyncRequestResponse[ListApiKeysRequest, ListApiKeysResponse](
        "listApiKeys",
        api.listApiKeys
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.ListApiKeysResponse.wrap)
        .provideEnvironment(r)
    def deleteResolver(
        request: zio.aws.appsync.model.DeleteResolverRequest
    ): IO[AwsError, zio.aws.appsync.model.DeleteResolverResponse.ReadOnly] =
      asyncRequestResponse[DeleteResolverRequest, DeleteResolverResponse](
        "deleteResolver",
        api.deleteResolver
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DeleteResolverResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.appsync.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.appsync.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteGraphqlApi(
        request: zio.aws.appsync.model.DeleteGraphqlApiRequest
    ): IO[AwsError, zio.aws.appsync.model.DeleteGraphqlApiResponse.ReadOnly] =
      asyncRequestResponse[DeleteGraphqlApiRequest, DeleteGraphqlApiResponse](
        "deleteGraphqlApi",
        api.deleteGraphqlApi
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DeleteGraphqlApiResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.appsync.model.TagResourceRequest
    ): IO[AwsError, zio.aws.appsync.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listFunctions(
        request: zio.aws.appsync.model.ListFunctionsRequest
    ): IO[AwsError, zio.aws.appsync.model.ListFunctionsResponse.ReadOnly] =
      asyncRequestResponse[ListFunctionsRequest, ListFunctionsResponse](
        "listFunctions",
        api.listFunctions
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.ListFunctionsResponse.wrap)
        .provideEnvironment(r)
    def disassociateMergedGraphqlApi(
        request: zio.aws.appsync.model.DisassociateMergedGraphqlApiRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.DisassociateMergedGraphqlApiResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateMergedGraphqlApiRequest,
      DisassociateMergedGraphqlApiResponse
    ]("disassociateMergedGraphqlApi", api.disassociateMergedGraphqlApi)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.DisassociateMergedGraphqlApiResponse.wrap)
      .provideEnvironment(r)
    def startSchemaCreation(
        request: zio.aws.appsync.model.StartSchemaCreationRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.StartSchemaCreationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartSchemaCreationRequest,
      StartSchemaCreationResponse
    ]("startSchemaCreation", api.startSchemaCreation)(request.buildAwsValue())
      .map(zio.aws.appsync.model.StartSchemaCreationResponse.wrap)
      .provideEnvironment(r)
    def associateApi(
        request: zio.aws.appsync.model.AssociateApiRequest
    ): IO[AwsError, zio.aws.appsync.model.AssociateApiResponse.ReadOnly] =
      asyncRequestResponse[AssociateApiRequest, AssociateApiResponse](
        "associateApi",
        api.associateApi
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.AssociateApiResponse.wrap)
        .provideEnvironment(r)
    def evaluateMappingTemplate(
        request: zio.aws.appsync.model.EvaluateMappingTemplateRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.EvaluateMappingTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      EvaluateMappingTemplateRequest,
      EvaluateMappingTemplateResponse
    ]("evaluateMappingTemplate", api.evaluateMappingTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.EvaluateMappingTemplateResponse.wrap)
      .provideEnvironment(r)
    def createResolver(
        request: zio.aws.appsync.model.CreateResolverRequest
    ): IO[AwsError, zio.aws.appsync.model.CreateResolverResponse.ReadOnly] =
      asyncRequestResponse[CreateResolverRequest, CreateResolverResponse](
        "createResolver",
        api.createResolver
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.CreateResolverResponse.wrap)
        .provideEnvironment(r)
    def deleteType(
        request: zio.aws.appsync.model.DeleteTypeRequest
    ): IO[AwsError, zio.aws.appsync.model.DeleteTypeResponse.ReadOnly] =
      asyncRequestResponse[DeleteTypeRequest, DeleteTypeResponse](
        "deleteType",
        api.deleteType
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DeleteTypeResponse.wrap)
        .provideEnvironment(r)
    def listSourceApiAssociations(
        request: zio.aws.appsync.model.ListSourceApiAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.ListSourceApiAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSourceApiAssociationsRequest,
      ListSourceApiAssociationsResponse
    ]("listSourceApiAssociations", api.listSourceApiAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.ListSourceApiAssociationsResponse.wrap)
      .provideEnvironment(r)
    def listDomainNames(
        request: zio.aws.appsync.model.ListDomainNamesRequest
    ): IO[AwsError, zio.aws.appsync.model.ListDomainNamesResponse.ReadOnly] =
      asyncRequestResponse[ListDomainNamesRequest, ListDomainNamesResponse](
        "listDomainNames",
        api.listDomainNames
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.ListDomainNamesResponse.wrap)
        .provideEnvironment(r)
    def getGraphqlApi(
        request: zio.aws.appsync.model.GetGraphqlApiRequest
    ): IO[AwsError, zio.aws.appsync.model.GetGraphqlApiResponse.ReadOnly] =
      asyncRequestResponse[GetGraphqlApiRequest, GetGraphqlApiResponse](
        "getGraphqlApi",
        api.getGraphqlApi
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.GetGraphqlApiResponse.wrap)
        .provideEnvironment(r)
    def getApiAssociation(
        request: zio.aws.appsync.model.GetApiAssociationRequest
    ): IO[AwsError, zio.aws.appsync.model.GetApiAssociationResponse.ReadOnly] =
      asyncRequestResponse[GetApiAssociationRequest, GetApiAssociationResponse](
        "getApiAssociation",
        api.getApiAssociation
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.GetApiAssociationResponse.wrap)
        .provideEnvironment(r)
    def disassociateSourceGraphqlApi(
        request: zio.aws.appsync.model.DisassociateSourceGraphqlApiRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateSourceGraphqlApiRequest,
      DisassociateSourceGraphqlApiResponse
    ]("disassociateSourceGraphqlApi", api.disassociateSourceGraphqlApi)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse.wrap)
      .provideEnvironment(r)
    def createFunction(
        request: zio.aws.appsync.model.CreateFunctionRequest
    ): IO[AwsError, zio.aws.appsync.model.CreateFunctionResponse.ReadOnly] =
      asyncRequestResponse[CreateFunctionRequest, CreateFunctionResponse](
        "createFunction",
        api.createFunction
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.CreateFunctionResponse.wrap)
        .provideEnvironment(r)
    def getDomainName(
        request: zio.aws.appsync.model.GetDomainNameRequest
    ): IO[AwsError, zio.aws.appsync.model.GetDomainNameResponse.ReadOnly] =
      asyncRequestResponse[GetDomainNameRequest, GetDomainNameResponse](
        "getDomainName",
        api.getDomainName
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.GetDomainNameResponse.wrap)
        .provideEnvironment(r)
    def deleteDomainName(
        request: zio.aws.appsync.model.DeleteDomainNameRequest
    ): IO[AwsError, zio.aws.appsync.model.DeleteDomainNameResponse.ReadOnly] =
      asyncRequestResponse[DeleteDomainNameRequest, DeleteDomainNameResponse](
        "deleteDomainName",
        api.deleteDomainName
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.DeleteDomainNameResponse.wrap)
        .provideEnvironment(r)
    def getFunction(
        request: zio.aws.appsync.model.GetFunctionRequest
    ): IO[AwsError, zio.aws.appsync.model.GetFunctionResponse.ReadOnly] =
      asyncRequestResponse[GetFunctionRequest, GetFunctionResponse](
        "getFunction",
        api.getFunction
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.GetFunctionResponse.wrap)
        .provideEnvironment(r)
    def updateDomainName(
        request: zio.aws.appsync.model.UpdateDomainNameRequest
    ): IO[AwsError, zio.aws.appsync.model.UpdateDomainNameResponse.ReadOnly] =
      asyncRequestResponse[UpdateDomainNameRequest, UpdateDomainNameResponse](
        "updateDomainName",
        api.updateDomainName
      )(request.buildAwsValue())
        .map(zio.aws.appsync.model.UpdateDomainNameResponse.wrap)
        .provideEnvironment(r)
    def listResolversByFunction(
        request: zio.aws.appsync.model.ListResolversByFunctionRequest
    ): IO[
      AwsError,
      zio.aws.appsync.model.ListResolversByFunctionResponse.ReadOnly
    ] = asyncRequestResponse[
      ListResolversByFunctionRequest,
      ListResolversByFunctionResponse
    ]("listResolversByFunction", api.listResolversByFunction)(
      request.buildAwsValue()
    ).map(zio.aws.appsync.model.ListResolversByFunctionResponse.wrap)
      .provideEnvironment(r)
  }
  def listTypes(request: zio.aws.appsync.model.ListTypesRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTypes(request))
  def updateType(request: zio.aws.appsync.model.UpdateTypeRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateType(request))
  def getDataSource(request: zio.aws.appsync.model.GetDataSourceRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataSource(request))
  def getApiCache(request: zio.aws.appsync.model.GetApiCacheRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetApiCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApiCache(request))
  def getSourceApiAssociation(
      request: zio.aws.appsync.model.GetSourceApiAssociationRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetSourceApiAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSourceApiAssociation(request))
  def updateSourceApiAssociation(
      request: zio.aws.appsync.model.UpdateSourceApiAssociationRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateSourceApiAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSourceApiAssociation(request))
  def associateMergedGraphqlApi(
      request: zio.aws.appsync.model.AssociateMergedGraphqlApiRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.AssociateMergedGraphqlApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateMergedGraphqlApi(request))
  def createApiCache(request: zio.aws.appsync.model.CreateApiCacheRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.CreateApiCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApiCache(request))
  def updateApiKey(request: zio.aws.appsync.model.UpdateApiKeyRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateApiKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApiKey(request))
  def listTypesByAssociation(
      request: zio.aws.appsync.model.ListTypesByAssociationRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListTypesByAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTypesByAssociation(request))
  def getIntrospectionSchema(
      request: zio.aws.appsync.model.GetIntrospectionSchemaRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetIntrospectionSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIntrospectionSchema(request))
  def flushApiCache(request: zio.aws.appsync.model.FlushApiCacheRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.FlushApiCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.flushApiCache(request))
  def associateSourceGraphqlApi(
      request: zio.aws.appsync.model.AssociateSourceGraphqlApiRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.AssociateSourceGraphqlApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSourceGraphqlApi(request))
  def updateApiCache(request: zio.aws.appsync.model.UpdateApiCacheRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApiCache(request))
  def createDataSource(
      request: zio.aws.appsync.model.CreateDataSourceRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.CreateDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataSource(request))
  def disassociateApi(
      request: zio.aws.appsync.model.DisassociateApiRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DisassociateApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateApi(request))
  def startSchemaMerge(
      request: zio.aws.appsync.model.StartSchemaMergeRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.StartSchemaMergeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSchemaMerge(request))
  def deleteApiCache(request: zio.aws.appsync.model.DeleteApiCacheRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DeleteApiCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApiCache(request))
  def deleteFunction(request: zio.aws.appsync.model.DeleteFunctionRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DeleteFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFunction(request))
  def evaluateCode(request: zio.aws.appsync.model.EvaluateCodeRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.EvaluateCodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.evaluateCode(request))
  def listDataSources(
      request: zio.aws.appsync.model.ListDataSourcesRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataSources(request))
  def createDomainName(
      request: zio.aws.appsync.model.CreateDomainNameRequest
  ): ZIO[zio.aws.appsync.AppSync, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createDomainName(request))
  def createGraphqlApi(
      request: zio.aws.appsync.model.CreateGraphqlApiRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.CreateGraphqlApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGraphqlApi(request))
  def getType(request: zio.aws.appsync.model.GetTypeRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getType(request))
  def getResolver(request: zio.aws.appsync.model.GetResolverRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetResolverResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResolver(request))
  def getSchemaCreationStatus(
      request: zio.aws.appsync.model.GetSchemaCreationStatusRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetSchemaCreationStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSchemaCreationStatus(request))
  def updateGraphqlApi(
      request: zio.aws.appsync.model.UpdateGraphqlApiRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateGraphqlApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGraphqlApi(request))
  def createType(request: zio.aws.appsync.model.CreateTypeRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.CreateTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createType(request))
  def listResolvers(request: zio.aws.appsync.model.ListResolversRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListResolversResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolvers(request))
  def untagResource(request: zio.aws.appsync.model.UntagResourceRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listGraphqlApis(
      request: zio.aws.appsync.model.ListGraphqlApisRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGraphqlApis(request))
  def updateDataSource(
      request: zio.aws.appsync.model.UpdateDataSourceRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataSource(request))
  def deleteApiKey(request: zio.aws.appsync.model.DeleteApiKeyRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DeleteApiKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApiKey(request))
  def updateResolver(request: zio.aws.appsync.model.UpdateResolverRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateResolverResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResolver(request))
  def createApiKey(request: zio.aws.appsync.model.CreateApiKeyRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.CreateApiKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApiKey(request))
  def updateFunction(request: zio.aws.appsync.model.UpdateFunctionRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFunction(request))
  def deleteDataSource(
      request: zio.aws.appsync.model.DeleteDataSourceRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DeleteDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataSource(request))
  def listApiKeys(request: zio.aws.appsync.model.ListApiKeysRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListApiKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApiKeys(request))
  def deleteResolver(request: zio.aws.appsync.model.DeleteResolverRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DeleteResolverResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResolver(request))
  def listTagsForResource(
      request: zio.aws.appsync.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteGraphqlApi(
      request: zio.aws.appsync.model.DeleteGraphqlApiRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DeleteGraphqlApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGraphqlApi(request))
  def tagResource(request: zio.aws.appsync.model.TagResourceRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listFunctions(request: zio.aws.appsync.model.ListFunctionsRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListFunctionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFunctions(request))
  def disassociateMergedGraphqlApi(
      request: zio.aws.appsync.model.DisassociateMergedGraphqlApiRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DisassociateMergedGraphqlApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMergedGraphqlApi(request))
  def startSchemaCreation(
      request: zio.aws.appsync.model.StartSchemaCreationRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.StartSchemaCreationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSchemaCreation(request))
  def associateApi(request: zio.aws.appsync.model.AssociateApiRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.AssociateApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateApi(request))
  def evaluateMappingTemplate(
      request: zio.aws.appsync.model.EvaluateMappingTemplateRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.EvaluateMappingTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.evaluateMappingTemplate(request))
  def createResolver(request: zio.aws.appsync.model.CreateResolverRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.CreateResolverResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createResolver(request))
  def deleteType(request: zio.aws.appsync.model.DeleteTypeRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DeleteTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteType(request))
  def listSourceApiAssociations(
      request: zio.aws.appsync.model.ListSourceApiAssociationsRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListSourceApiAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSourceApiAssociations(request))
  def listDomainNames(
      request: zio.aws.appsync.model.ListDomainNamesRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListDomainNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainNames(request))
  def getGraphqlApi(request: zio.aws.appsync.model.GetGraphqlApiRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetGraphqlApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGraphqlApi(request))
  def getApiAssociation(
      request: zio.aws.appsync.model.GetApiAssociationRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetApiAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApiAssociation(request))
  def disassociateSourceGraphqlApi(
      request: zio.aws.appsync.model.DisassociateSourceGraphqlApiRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateSourceGraphqlApi(request))
  def createFunction(request: zio.aws.appsync.model.CreateFunctionRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.CreateFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFunction(request))
  def getDomainName(request: zio.aws.appsync.model.GetDomainNameRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainName(request))
  def deleteDomainName(
      request: zio.aws.appsync.model.DeleteDomainNameRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.DeleteDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDomainName(request))
  def getFunction(request: zio.aws.appsync.model.GetFunctionRequest): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.GetFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFunction(request))
  def updateDomainName(
      request: zio.aws.appsync.model.UpdateDomainNameRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.UpdateDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomainName(request))
  def listResolversByFunction(
      request: zio.aws.appsync.model.ListResolversByFunctionRequest
  ): ZIO[
    zio.aws.appsync.AppSync,
    AwsError,
    zio.aws.appsync.model.ListResolversByFunctionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResolversByFunction(request))
}
