package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.{
  CodeErrorSpan,
  CodeErrorColumn,
  CodeErrorLine
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CodeErrorLocation(
    line: Optional[CodeErrorLine] = Optional.Absent,
    column: Optional[CodeErrorColumn] = Optional.Absent,
    span: Optional[CodeErrorSpan] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CodeErrorLocation = {
    import CodeErrorLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CodeErrorLocation
      .builder()
      .optionallyWith(line.map(value => CodeErrorLine.unwrap(value): Integer))(
        _.line
      )
      .optionallyWith(
        column.map(value => CodeErrorColumn.unwrap(value): Integer)
      )(_.column)
      .optionallyWith(span.map(value => CodeErrorSpan.unwrap(value): Integer))(
        _.span
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CodeErrorLocation.ReadOnly =
    zio.aws.appsync.model.CodeErrorLocation.wrap(buildAwsValue())
}
object CodeErrorLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CodeErrorLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CodeErrorLocation =
      zio.aws.appsync.model.CodeErrorLocation(
        line.map(value => value),
        column.map(value => value),
        span.map(value => value)
      )
    def line: Optional[CodeErrorLine]
    def column: Optional[CodeErrorColumn]
    def span: Optional[CodeErrorSpan]
    def getLine: ZIO[Any, AwsError, CodeErrorLine] =
      AwsError.unwrapOptionField("line", line)
    def getColumn: ZIO[Any, AwsError, CodeErrorColumn] =
      AwsError.unwrapOptionField("column", column)
    def getSpan: ZIO[Any, AwsError, CodeErrorSpan] =
      AwsError.unwrapOptionField("span", span)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CodeErrorLocation
  ) extends zio.aws.appsync.model.CodeErrorLocation.ReadOnly {
    override val line: Optional[CodeErrorLine] = zio.aws.core.internal
      .optionalFromNullable(impl.line())
      .map(value => zio.aws.appsync.model.primitives.CodeErrorLine(value))
    override val column: Optional[CodeErrorColumn] = zio.aws.core.internal
      .optionalFromNullable(impl.column())
      .map(value => zio.aws.appsync.model.primitives.CodeErrorColumn(value))
    override val span: Optional[CodeErrorSpan] = zio.aws.core.internal
      .optionalFromNullable(impl.span())
      .map(value => zio.aws.appsync.model.primitives.CodeErrorSpan(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CodeErrorLocation
  ): zio.aws.appsync.model.CodeErrorLocation.ReadOnly = new Wrapper(impl)
}
