package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSourceApiAssociationsResponse(
    sourceApiAssociationSummaries: Optional[
      Iterable[zio.aws.appsync.model.SourceApiAssociationSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse = {
    import ListSourceApiAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse
      .builder()
      .optionallyWith(
        sourceApiAssociationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceApiAssociationSummaries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.ListSourceApiAssociationsResponse.ReadOnly =
    zio.aws.appsync.model.ListSourceApiAssociationsResponse
      .wrap(buildAwsValue())
}
object ListSourceApiAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListSourceApiAssociationsResponse =
      zio.aws.appsync.model.ListSourceApiAssociationsResponse(
        sourceApiAssociationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sourceApiAssociationSummaries: Optional[
      List[zio.aws.appsync.model.SourceApiAssociationSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getSourceApiAssociationSummaries: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.SourceApiAssociationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceApiAssociationSummaries",
      sourceApiAssociationSummaries
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse
  ) extends zio.aws.appsync.model.ListSourceApiAssociationsResponse.ReadOnly {
    override val sourceApiAssociationSummaries: Optional[
      List[zio.aws.appsync.model.SourceApiAssociationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceApiAssociationSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.SourceApiAssociationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse
  ): zio.aws.appsync.model.ListSourceApiAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
