package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSourceApiAssociationRequest(
    mergedApiIdentifier: String,
    associationId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest = {
    import GetSourceApiAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest
      .builder()
      .mergedApiIdentifier(mergedApiIdentifier: java.lang.String)
      .associationId(associationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.GetSourceApiAssociationRequest.ReadOnly =
    zio.aws.appsync.model.GetSourceApiAssociationRequest.wrap(buildAwsValue())
}
object GetSourceApiAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetSourceApiAssociationRequest =
      zio.aws.appsync.model
        .GetSourceApiAssociationRequest(mergedApiIdentifier, associationId)
    def mergedApiIdentifier: String
    def associationId: String
    def getMergedApiIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(mergedApiIdentifier)
    def getAssociationId: ZIO[Any, Nothing, String] = ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest
  ) extends zio.aws.appsync.model.GetSourceApiAssociationRequest.ReadOnly {
    override val mergedApiIdentifier: String =
      impl.mergedApiIdentifier(): String
    override val associationId: String = impl.associationId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest
  ): zio.aws.appsync.model.GetSourceApiAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
