package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateSourceGraphqlApiResponse(
    sourceApiAssociationStatus: Optional[
      zio.aws.appsync.model.SourceApiAssociationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiResponse = {
    import DisassociateSourceGraphqlApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiResponse
      .builder()
      .optionallyWith(sourceApiAssociationStatus.map(value => value.unwrap))(
        _.sourceApiAssociationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse.ReadOnly =
    zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse
      .wrap(buildAwsValue())
}
object DisassociateSourceGraphqlApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse =
      zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse(
        sourceApiAssociationStatus.map(value => value)
      )
    def sourceApiAssociationStatus
        : Optional[zio.aws.appsync.model.SourceApiAssociationStatus]
    def getSourceApiAssociationStatus
        : ZIO[Any, AwsError, zio.aws.appsync.model.SourceApiAssociationStatus] =
      AwsError.unwrapOptionField(
        "sourceApiAssociationStatus",
        sourceApiAssociationStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiResponse
  ) extends zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse.ReadOnly {
    override val sourceApiAssociationStatus
        : Optional[zio.aws.appsync.model.SourceApiAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociationStatus())
        .map(value =>
          zio.aws.appsync.model.SourceApiAssociationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiResponse
  ): zio.aws.appsync.model.DisassociateSourceGraphqlApiResponse.ReadOnly =
    new Wrapper(impl)
}
