package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFunctionResponse(
    functionConfiguration: Optional[
      zio.aws.appsync.model.FunctionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse = {
    import UpdateFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse
      .builder()
      .optionallyWith(
        functionConfiguration.map(value => value.buildAwsValue())
      )(_.functionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly =
    zio.aws.appsync.model.UpdateFunctionResponse.wrap(buildAwsValue())
}
object UpdateFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateFunctionResponse =
      zio.aws.appsync.model.UpdateFunctionResponse(
        functionConfiguration.map(value => value.asEditable)
      )
    def functionConfiguration
        : Optional[zio.aws.appsync.model.FunctionConfiguration.ReadOnly]
    def getFunctionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.FunctionConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("functionConfiguration", functionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse
  ) extends zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly {
    override val functionConfiguration
        : Optional[zio.aws.appsync.model.FunctionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionConfiguration())
        .map(value => zio.aws.appsync.model.FunctionConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse
  ): zio.aws.appsync.model.UpdateFunctionResponse.ReadOnly = new Wrapper(impl)
}
