package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EventBridgeDataSourceConfig(eventBusArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.EventBridgeDataSourceConfig = {
    import EventBridgeDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.EventBridgeDataSourceConfig
      .builder()
      .eventBusArn(eventBusArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.EventBridgeDataSourceConfig.ReadOnly =
    zio.aws.appsync.model.EventBridgeDataSourceConfig.wrap(buildAwsValue())
}
object EventBridgeDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.EventBridgeDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.EventBridgeDataSourceConfig =
      zio.aws.appsync.model.EventBridgeDataSourceConfig(eventBusArn)
    def eventBusArn: String
    def getEventBusArn: ZIO[Any, Nothing, String] = ZIO.succeed(eventBusArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.EventBridgeDataSourceConfig
  ) extends zio.aws.appsync.model.EventBridgeDataSourceConfig.ReadOnly {
    override val eventBusArn: String = impl.eventBusArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.EventBridgeDataSourceConfig
  ): zio.aws.appsync.model.EventBridgeDataSourceConfig.ReadOnly = new Wrapper(
    impl
  )
}
