package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateSourceGraphqlApiRequest(
    mergedApiIdentifier: String,
    associationId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest = {
    import DisassociateSourceGraphqlApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest
      .builder()
      .mergedApiIdentifier(mergedApiIdentifier: java.lang.String)
      .associationId(associationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.DisassociateSourceGraphqlApiRequest.ReadOnly =
    zio.aws.appsync.model.DisassociateSourceGraphqlApiRequest
      .wrap(buildAwsValue())
}
object DisassociateSourceGraphqlApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DisassociateSourceGraphqlApiRequest =
      zio.aws.appsync.model
        .DisassociateSourceGraphqlApiRequest(mergedApiIdentifier, associationId)
    def mergedApiIdentifier: String
    def associationId: String
    def getMergedApiIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(mergedApiIdentifier)
    def getAssociationId: ZIO[Any, Nothing, String] = ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest
  ) extends zio.aws.appsync.model.DisassociateSourceGraphqlApiRequest.ReadOnly {
    override val mergedApiIdentifier: String =
      impl.mergedApiIdentifier(): String
    override val associationId: String = impl.associationId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest
  ): zio.aws.appsync.model.DisassociateSourceGraphqlApiRequest.ReadOnly =
    new Wrapper(impl)
}
