package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{TagValue, TagKey, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GraphqlApi(
    name: Optional[ResourceName] = Optional.Absent,
    apiId: Optional[String] = Optional.Absent,
    authenticationType: Optional[zio.aws.appsync.model.AuthenticationType] =
      Optional.Absent,
    logConfig: Optional[zio.aws.appsync.model.LogConfig] = Optional.Absent,
    userPoolConfig: Optional[zio.aws.appsync.model.UserPoolConfig] =
      Optional.Absent,
    openIDConnectConfig: Optional[zio.aws.appsync.model.OpenIDConnectConfig] =
      Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    uris: Optional[Map[String, String]] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    additionalAuthenticationProviders: Optional[
      Iterable[zio.aws.appsync.model.AdditionalAuthenticationProvider]
    ] = Optional.Absent,
    xrayEnabled: Optional[Boolean] = Optional.Absent,
    wafWebAclArn: Optional[String] = Optional.Absent,
    lambdaAuthorizerConfig: Optional[
      zio.aws.appsync.model.LambdaAuthorizerConfig
    ] = Optional.Absent,
    dns: Optional[Map[String, String]] = Optional.Absent,
    visibility: Optional[zio.aws.appsync.model.GraphQLApiVisibility] =
      Optional.Absent,
    apiType: Optional[zio.aws.appsync.model.GraphQLApiType] = Optional.Absent,
    mergedApiExecutionRoleArn: Optional[String] = Optional.Absent,
    owner: Optional[String] = Optional.Absent,
    ownerContact: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GraphqlApi = {
    import GraphqlApi.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GraphqlApi
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(apiId.map(value => value: java.lang.String))(_.apiId)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .optionallyWith(openIDConnectConfig.map(value => value.buildAwsValue()))(
        _.openIDConnectConfig
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        uris.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.uris)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthenticationProviders)
      .optionallyWith(xrayEnabled.map(value => value: java.lang.Boolean))(
        _.xrayEnabled
      )
      .optionallyWith(wafWebAclArn.map(value => value: java.lang.String))(
        _.wafWebAclArn
      )
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .optionallyWith(
        dns.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.dns)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(apiType.map(value => value.unwrap))(_.apiType)
      .optionallyWith(
        mergedApiExecutionRoleArn.map(value => value: java.lang.String)
      )(_.mergedApiExecutionRoleArn)
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .optionallyWith(ownerContact.map(value => value: java.lang.String))(
        _.ownerContact
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GraphqlApi.ReadOnly =
    zio.aws.appsync.model.GraphqlApi.wrap(buildAwsValue())
}
object GraphqlApi {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GraphqlApi
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GraphqlApi =
      zio.aws.appsync.model.GraphqlApi(
        name.map(value => value),
        apiId.map(value => value),
        authenticationType.map(value => value),
        logConfig.map(value => value.asEditable),
        userPoolConfig.map(value => value.asEditable),
        openIDConnectConfig.map(value => value.asEditable),
        arn.map(value => value),
        uris.map(value => value),
        tags.map(value => value),
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        xrayEnabled.map(value => value),
        wafWebAclArn.map(value => value),
        lambdaAuthorizerConfig.map(value => value.asEditable),
        dns.map(value => value),
        visibility.map(value => value),
        apiType.map(value => value),
        mergedApiExecutionRoleArn.map(value => value),
        owner.map(value => value),
        ownerContact.map(value => value)
      )
    def name: Optional[ResourceName]
    def apiId: Optional[String]
    def authenticationType: Optional[zio.aws.appsync.model.AuthenticationType]
    def logConfig: Optional[zio.aws.appsync.model.LogConfig.ReadOnly]
    def userPoolConfig: Optional[zio.aws.appsync.model.UserPoolConfig.ReadOnly]
    def openIDConnectConfig
        : Optional[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly]
    def arn: Optional[String]
    def uris: Optional[Map[String, String]]
    def tags: Optional[Map[TagKey, TagValue]]
    def additionalAuthenticationProviders: Optional[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ]
    def xrayEnabled: Optional[Boolean]
    def wafWebAclArn: Optional[String]
    def lambdaAuthorizerConfig
        : Optional[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly]
    def dns: Optional[Map[String, String]]
    def visibility: Optional[zio.aws.appsync.model.GraphQLApiVisibility]
    def apiType: Optional[zio.aws.appsync.model.GraphQLApiType]
    def mergedApiExecutionRoleArn: Optional[String]
    def owner: Optional[String]
    def ownerContact: Optional[String]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appsync.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getLogConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.LogConfig.ReadOnly] =
      AwsError.unwrapOptionField("logConfig", logConfig)
    def getUserPoolConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
    def getOpenIDConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("openIDConnectConfig", openIDConnectConfig)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getUris: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("uris", uris)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAdditionalAuthenticationProviders: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalAuthenticationProviders",
      additionalAuthenticationProviders
    )
    def getXrayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("xrayEnabled", xrayEnabled)
    def getWafWebAclArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("wafWebAclArn", wafWebAclArn)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
    def getDns: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("dns", dns)
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.appsync.model.GraphQLApiVisibility] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getApiType: ZIO[Any, AwsError, zio.aws.appsync.model.GraphQLApiType] =
      AwsError.unwrapOptionField("apiType", apiType)
    def getMergedApiExecutionRoleArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("mergedApiExecutionRoleArn", mergedApiExecutionRoleArn)
    def getOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("owner", owner)
    def getOwnerContact: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerContact", ownerContact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GraphqlApi
  ) extends zio.aws.appsync.model.GraphqlApi.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val apiId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.apiId())
      .map(value => value: String)
    override val authenticationType
        : Optional[zio.aws.appsync.model.AuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value => zio.aws.appsync.model.AuthenticationType.wrap(value))
    override val logConfig: Optional[zio.aws.appsync.model.LogConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfig())
        .map(value => zio.aws.appsync.model.LogConfig.wrap(value))
    override val userPoolConfig
        : Optional[zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPoolConfig())
        .map(value => zio.aws.appsync.model.UserPoolConfig.wrap(value))
    override val openIDConnectConfig
        : Optional[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openIDConnectConfig())
        .map(value => zio.aws.appsync.model.OpenIDConnectConfig.wrap(value))
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val uris: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.uris())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appsync.model.primitives
              .TagKey(key) -> zio.aws.appsync.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val additionalAuthenticationProviders: Optional[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAuthenticationProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.AdditionalAuthenticationProvider.wrap(item)
        }.toList
      )
    override val xrayEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.xrayEnabled())
      .map(value => value: Boolean)
    override val wafWebAclArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.wafWebAclArn())
      .map(value => value: String)
    override val lambdaAuthorizerConfig
        : Optional[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaAuthorizerConfig())
        .map(value => zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(value))
    override val dns: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.dns())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val visibility
        : Optional[zio.aws.appsync.model.GraphQLApiVisibility] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visibility())
        .map(value => zio.aws.appsync.model.GraphQLApiVisibility.wrap(value))
    override val apiType: Optional[zio.aws.appsync.model.GraphQLApiType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiType())
        .map(value => zio.aws.appsync.model.GraphQLApiType.wrap(value))
    override val mergedApiExecutionRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergedApiExecutionRoleArn())
        .map(value => value: String)
    override val owner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => value: String)
    override val ownerContact: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerContact())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GraphqlApi
  ): zio.aws.appsync.model.GraphqlApi.ReadOnly = new Wrapper(impl)
}
