package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait ApiCacheStatus {
  def unwrap: software.amazon.awssdk.services.appsync.model.ApiCacheStatus
}
object ApiCacheStatus {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.ApiCacheStatus
  ): zio.aws.appsync.model.ApiCacheStatus = value match {
    case software.amazon.awssdk.services.appsync.model.ApiCacheStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheStatus.MODIFYING =>
      val r = MODIFYING
      r
    case software.amazon.awssdk.services.appsync.model.ApiCacheStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.ApiCacheStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheStatus =
      software.amazon.awssdk.services.appsync.model.ApiCacheStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.appsync.model.ApiCacheStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheStatus =
      software.amazon.awssdk.services.appsync.model.ApiCacheStatus.AVAILABLE
  }
  case object CREATING extends zio.aws.appsync.model.ApiCacheStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheStatus =
      software.amazon.awssdk.services.appsync.model.ApiCacheStatus.CREATING
  }
  case object DELETING extends zio.aws.appsync.model.ApiCacheStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheStatus =
      software.amazon.awssdk.services.appsync.model.ApiCacheStatus.DELETING
  }
  case object MODIFYING extends zio.aws.appsync.model.ApiCacheStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheStatus =
      software.amazon.awssdk.services.appsync.model.ApiCacheStatus.MODIFYING
  }
  case object FAILED extends zio.aws.appsync.model.ApiCacheStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCacheStatus =
      software.amazon.awssdk.services.appsync.model.ApiCacheStatus.FAILED
  }
}
