package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CognitoUserPoolConfig(
    userPoolId: String,
    awsRegion: String,
    appIdClientRegex: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CognitoUserPoolConfig = {
    import CognitoUserPoolConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CognitoUserPoolConfig
      .builder()
      .userPoolId(userPoolId: java.lang.String)
      .awsRegion(awsRegion: java.lang.String)
      .optionallyWith(appIdClientRegex.map(value => value: java.lang.String))(
        _.appIdClientRegex
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CognitoUserPoolConfig.ReadOnly =
    zio.aws.appsync.model.CognitoUserPoolConfig.wrap(buildAwsValue())
}
object CognitoUserPoolConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CognitoUserPoolConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CognitoUserPoolConfig =
      zio.aws.appsync.model.CognitoUserPoolConfig(
        userPoolId,
        awsRegion,
        appIdClientRegex.map(value => value)
      )
    def userPoolId: String
    def awsRegion: String
    def appIdClientRegex: Optional[String]
    def getUserPoolId: ZIO[Any, Nothing, String] = ZIO.succeed(userPoolId)
    def getAwsRegion: ZIO[Any, Nothing, String] = ZIO.succeed(awsRegion)
    def getAppIdClientRegex: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("appIdClientRegex", appIdClientRegex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CognitoUserPoolConfig
  ) extends zio.aws.appsync.model.CognitoUserPoolConfig.ReadOnly {
    override val userPoolId: String = impl.userPoolId(): String
    override val awsRegion: String = impl.awsRegion(): String
    override val appIdClientRegex: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.appIdClientRegex())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CognitoUserPoolConfig
  ): zio.aws.appsync.model.CognitoUserPoolConfig.ReadOnly = new Wrapper(impl)
}
