package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDataSourceRequest(
    apiId: String,
    name: ResourceName,
    description: Optional[String] = Optional.Absent,
    `type`: zio.aws.appsync.model.DataSourceType,
    serviceRoleArn: Optional[String] = Optional.Absent,
    dynamodbConfig: Optional[zio.aws.appsync.model.DynamodbDataSourceConfig] =
      Optional.Absent,
    lambdaConfig: Optional[zio.aws.appsync.model.LambdaDataSourceConfig] =
      Optional.Absent,
    elasticsearchConfig: Optional[
      zio.aws.appsync.model.ElasticsearchDataSourceConfig
    ] = Optional.Absent,
    openSearchServiceConfig: Optional[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig
    ] = Optional.Absent,
    httpConfig: Optional[zio.aws.appsync.model.HttpDataSourceConfig] =
      Optional.Absent,
    relationalDatabaseConfig: Optional[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest = {
    import UpdateDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .`type`(`type`.unwrap)
      .optionallyWith(serviceRoleArn.map(value => value: java.lang.String))(
        _.serviceRoleArn
      )
      .optionallyWith(dynamodbConfig.map(value => value.buildAwsValue()))(
        _.dynamodbConfig
      )
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(elasticsearchConfig.map(value => value.buildAwsValue()))(
        _.elasticsearchConfig
      )
      .optionallyWith(
        openSearchServiceConfig.map(value => value.buildAwsValue())
      )(_.openSearchServiceConfig)
      .optionallyWith(httpConfig.map(value => value.buildAwsValue()))(
        _.httpConfig
      )
      .optionallyWith(
        relationalDatabaseConfig.map(value => value.buildAwsValue())
      )(_.relationalDatabaseConfig)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateDataSourceRequest.ReadOnly =
    zio.aws.appsync.model.UpdateDataSourceRequest.wrap(buildAwsValue())
}
object UpdateDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateDataSourceRequest =
      zio.aws.appsync.model.UpdateDataSourceRequest(
        apiId,
        name,
        description.map(value => value),
        `type`,
        serviceRoleArn.map(value => value),
        dynamodbConfig.map(value => value.asEditable),
        lambdaConfig.map(value => value.asEditable),
        elasticsearchConfig.map(value => value.asEditable),
        openSearchServiceConfig.map(value => value.asEditable),
        httpConfig.map(value => value.asEditable),
        relationalDatabaseConfig.map(value => value.asEditable)
      )
    def apiId: String
    def name: ResourceName
    def description: Optional[String]
    def `type`: zio.aws.appsync.model.DataSourceType
    def serviceRoleArn: Optional[String]
    def dynamodbConfig
        : Optional[zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly]
    def lambdaConfig
        : Optional[zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly]
    def elasticsearchConfig
        : Optional[zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly]
    def openSearchServiceConfig: Optional[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ]
    def httpConfig
        : Optional[zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly]
    def relationalDatabaseConfig: Optional[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, Nothing, zio.aws.appsync.model.DataSourceType] =
      ZIO.succeed(`type`)
    def getServiceRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getDynamodbConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dynamodbConfig", dynamodbConfig)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getElasticsearchConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("elasticsearchConfig", elasticsearchConfig)
    def getOpenSearchServiceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "openSearchServiceConfig",
      openSearchServiceConfig
    )
    def getHttpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("httpConfig", httpConfig)
    def getRelationalDatabaseConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "relationalDatabaseConfig",
      relationalDatabaseConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest
  ) extends zio.aws.appsync.model.UpdateDataSourceRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val name: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.name())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val `type`: zio.aws.appsync.model.DataSourceType =
      zio.aws.appsync.model.DataSourceType.wrap(impl.`type`())
    override val serviceRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRoleArn())
      .map(value => value: String)
    override val dynamodbConfig
        : Optional[zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamodbConfig())
        .map(value =>
          zio.aws.appsync.model.DynamodbDataSourceConfig.wrap(value)
        )
    override val lambdaConfig
        : Optional[zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaConfig())
        .map(value => zio.aws.appsync.model.LambdaDataSourceConfig.wrap(value))
    override val elasticsearchConfig: Optional[
      zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticsearchConfig())
      .map(value =>
        zio.aws.appsync.model.ElasticsearchDataSourceConfig.wrap(value)
      )
    override val openSearchServiceConfig: Optional[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openSearchServiceConfig())
      .map(value =>
        zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.wrap(value)
      )
    override val httpConfig
        : Optional[zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpConfig())
        .map(value => zio.aws.appsync.model.HttpDataSourceConfig.wrap(value))
    override val relationalDatabaseConfig: Optional[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relationalDatabaseConfig())
      .map(value =>
        zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest
  ): zio.aws.appsync.model.UpdateDataSourceRequest.ReadOnly = new Wrapper(impl)
}
