package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OpenSearchServiceDataSourceConfig(
    endpoint: String,
    awsRegion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.OpenSearchServiceDataSourceConfig = {
    import OpenSearchServiceDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.OpenSearchServiceDataSourceConfig
      .builder()
      .endpoint(endpoint: java.lang.String)
      .awsRegion(awsRegion: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly =
    zio.aws.appsync.model.OpenSearchServiceDataSourceConfig
      .wrap(buildAwsValue())
}
object OpenSearchServiceDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.OpenSearchServiceDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.OpenSearchServiceDataSourceConfig =
      zio.aws.appsync.model
        .OpenSearchServiceDataSourceConfig(endpoint, awsRegion)
    def endpoint: String
    def awsRegion: String
    def getEndpoint: ZIO[Any, Nothing, String] = ZIO.succeed(endpoint)
    def getAwsRegion: ZIO[Any, Nothing, String] = ZIO.succeed(awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.OpenSearchServiceDataSourceConfig
  ) extends zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly {
    override val endpoint: String = impl.endpoint(): String
    override val awsRegion: String = impl.awsRegion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.OpenSearchServiceDataSourceConfig
  ): zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly =
    new Wrapper(impl)
}
