package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDomainNameRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetDomainNameRequest = {
    import GetDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetDomainNameRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetDomainNameRequest.ReadOnly =
    zio.aws.appsync.model.GetDomainNameRequest.wrap(buildAwsValue())
}
object GetDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetDomainNameRequest =
      zio.aws.appsync.model.GetDomainNameRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetDomainNameRequest
  ) extends zio.aws.appsync.model.GetDomainNameRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.appsync.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetDomainNameRequest
  ): zio.aws.appsync.model.GetDomainNameRequest.ReadOnly = new Wrapper(impl)
}
