package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetResolverRequest(
    apiId: String,
    typeName: ResourceName,
    fieldName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetResolverRequest = {
    import GetResolverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetResolverRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .typeName(ResourceName.unwrap(typeName): java.lang.String)
      .fieldName(ResourceName.unwrap(fieldName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetResolverRequest.ReadOnly =
    zio.aws.appsync.model.GetResolverRequest.wrap(buildAwsValue())
}
object GetResolverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetResolverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetResolverRequest =
      zio.aws.appsync.model.GetResolverRequest(apiId, typeName, fieldName)
    def apiId: String
    def typeName: ResourceName
    def fieldName: ResourceName
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTypeName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(typeName)
    def getFieldName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(fieldName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetResolverRequest
  ) extends zio.aws.appsync.model.GetResolverRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val typeName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.typeName())
    override val fieldName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.fieldName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetResolverRequest
  ): zio.aws.appsync.model.GetResolverRequest.ReadOnly = new Wrapper(impl)
}
