package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait RelationalDatabaseSourceType {
  def unwrap: software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType
}
object RelationalDatabaseSourceType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType
  ): zio.aws.appsync.model.RelationalDatabaseSourceType = value match {
    case software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType.RDS_HTTP_ENDPOINT =>
      val r = RDS_HTTP_ENDPOINT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.RelationalDatabaseSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType =
      software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object RDS_HTTP_ENDPOINT
      extends zio.aws.appsync.model.RelationalDatabaseSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType =
      software.amazon.awssdk.services.appsync.model.RelationalDatabaseSourceType.RDS_HTTP_ENDPOINT
  }
}
