package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApiKeyRequest(
    apiId: String,
    description: Optional[String] = Optional.Absent,
    expires: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest = {
    import CreateApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(expires.map(value => value: java.lang.Long))(_.expires)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateApiKeyRequest.ReadOnly =
    zio.aws.appsync.model.CreateApiKeyRequest.wrap(buildAwsValue())
}
object CreateApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateApiKeyRequest =
      zio.aws.appsync.model.CreateApiKeyRequest(
        apiId,
        description.map(value => value),
        expires.map(value => value)
      )
    def apiId: String
    def description: Optional[String]
    def expires: Optional[Long]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getExpires: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("expires", expires)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest
  ) extends zio.aws.appsync.model.CreateApiKeyRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val expires: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest
  ): zio.aws.appsync.model.CreateApiKeyRequest.ReadOnly = new Wrapper(impl)
}
