package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait ApiCachingBehavior {
  def unwrap: software.amazon.awssdk.services.appsync.model.ApiCachingBehavior
}
object ApiCachingBehavior {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.ApiCachingBehavior
  ): zio.aws.appsync.model.ApiCachingBehavior = value match {
    case software.amazon.awssdk.services.appsync.model.ApiCachingBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.ApiCachingBehavior.FULL_REQUEST_CACHING =>
      val r = FULL_REQUEST_CACHING
      r
    case software.amazon.awssdk.services.appsync.model.ApiCachingBehavior.PER_RESOLVER_CACHING =>
      val r = PER_RESOLVER_CACHING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.ApiCachingBehavior {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCachingBehavior =
      software.amazon.awssdk.services.appsync.model.ApiCachingBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_REQUEST_CACHING
      extends zio.aws.appsync.model.ApiCachingBehavior {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCachingBehavior =
      software.amazon.awssdk.services.appsync.model.ApiCachingBehavior.FULL_REQUEST_CACHING
  }
  case object PER_RESOLVER_CACHING
      extends zio.aws.appsync.model.ApiCachingBehavior {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.ApiCachingBehavior =
      software.amazon.awssdk.services.appsync.model.ApiCachingBehavior.PER_RESOLVER_CACHING
  }
}
