package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.Blob
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetIntrospectionSchemaResponse(
    schema: Optional[Blob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse = {
    import GetIntrospectionSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse
      .builder()
      .optionallyWith(
        schema.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.schema)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.GetIntrospectionSchemaResponse.ReadOnly =
    zio.aws.appsync.model.GetIntrospectionSchemaResponse.wrap(buildAwsValue())
}
object GetIntrospectionSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetIntrospectionSchemaResponse =
      zio.aws.appsync.model
        .GetIntrospectionSchemaResponse(schema.map(value => value))
    def schema: Optional[Blob]
    def getSchema: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse
  ) extends zio.aws.appsync.model.GetIntrospectionSchemaResponse.ReadOnly {
    override val schema: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value =>
        zio.aws.appsync.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse
  ): zio.aws.appsync.model.GetIntrospectionSchemaResponse.ReadOnly =
    new Wrapper(impl)
}
