package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFunctionRequest(
    apiId: String,
    functionId: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest = {
    import DeleteFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .functionId(ResourceName.unwrap(functionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeleteFunctionRequest.ReadOnly =
    zio.aws.appsync.model.DeleteFunctionRequest.wrap(buildAwsValue())
}
object DeleteFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeleteFunctionRequest =
      zio.aws.appsync.model.DeleteFunctionRequest(apiId, functionId)
    def apiId: String
    def functionId: ResourceName
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getFunctionId: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(functionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest
  ) extends zio.aws.appsync.model.DeleteFunctionRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val functionId: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.functionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest
  ): zio.aws.appsync.model.DeleteFunctionRequest.ReadOnly = new Wrapper(impl)
}
