package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AdditionalAuthenticationProvider(
    authenticationType: Option[zio.aws.appsync.model.AuthenticationType] = None,
    openIDConnectConfig: Option[zio.aws.appsync.model.OpenIDConnectConfig] =
      None,
    userPoolConfig: Option[zio.aws.appsync.model.CognitoUserPoolConfig] = None,
    lambdaAuthorizerConfig: Option[
      zio.aws.appsync.model.LambdaAuthorizerConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider = {
    import AdditionalAuthenticationProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider
      .builder()
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(openIDConnectConfig.map(value => value.buildAwsValue()))(
        _.openIDConnectConfig
      )
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly =
    zio.aws.appsync.model.AdditionalAuthenticationProvider.wrap(buildAwsValue())
}
object AdditionalAuthenticationProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AdditionalAuthenticationProvider =
      zio.aws.appsync.model.AdditionalAuthenticationProvider(
        authenticationType.map(value => value),
        openIDConnectConfig.map(value => value.asEditable),
        userPoolConfig.map(value => value.asEditable),
        lambdaAuthorizerConfig.map(value => value.asEditable)
      )
    def authenticationType: Option[zio.aws.appsync.model.AuthenticationType]
    def openIDConnectConfig
        : Option[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly]
    def userPoolConfig
        : Option[zio.aws.appsync.model.CognitoUserPoolConfig.ReadOnly]
    def lambdaAuthorizerConfig
        : Option[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly]
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appsync.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getOpenIDConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("openIDConnectConfig", openIDConnectConfig)
    def getUserPoolConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.CognitoUserPoolConfig.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider
  ) extends zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly {
    override val authenticationType
        : Option[zio.aws.appsync.model.AuthenticationType] = scala
      .Option(impl.authenticationType())
      .map(value => zio.aws.appsync.model.AuthenticationType.wrap(value))
    override val openIDConnectConfig
        : Option[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly] = scala
      .Option(impl.openIDConnectConfig())
      .map(value => zio.aws.appsync.model.OpenIDConnectConfig.wrap(value))
    override val userPoolConfig
        : Option[zio.aws.appsync.model.CognitoUserPoolConfig.ReadOnly] = scala
      .Option(impl.userPoolConfig())
      .map(value => zio.aws.appsync.model.CognitoUserPoolConfig.wrap(value))
    override val lambdaAuthorizerConfig
        : Option[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly] = scala
      .Option(impl.lambdaAuthorizerConfig())
      .map(value => zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AdditionalAuthenticationProvider
  ): zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly =
    new Wrapper(impl)
}
