package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetGraphqlApiResponse(
    graphqlApi: Option[zio.aws.appsync.model.GraphqlApi] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse = {
    import GetGraphqlApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse
      .builder()
      .optionallyWith(graphqlApi.map(value => value.buildAwsValue()))(
        _.graphqlApi
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetGraphqlApiResponse.ReadOnly =
    zio.aws.appsync.model.GetGraphqlApiResponse.wrap(buildAwsValue())
}
object GetGraphqlApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetGraphqlApiResponse =
      zio.aws.appsync.model
        .GetGraphqlApiResponse(graphqlApi.map(value => value.asEditable))
    def graphqlApi: Option[zio.aws.appsync.model.GraphqlApi.ReadOnly]
    def getGraphqlApi
        : ZIO[Any, AwsError, zio.aws.appsync.model.GraphqlApi.ReadOnly] =
      AwsError.unwrapOptionField("graphqlApi", graphqlApi)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse
  ) extends zio.aws.appsync.model.GetGraphqlApiResponse.ReadOnly {
    override val graphqlApi: Option[zio.aws.appsync.model.GraphqlApi.ReadOnly] =
      scala
        .Option(impl.graphqlApi())
        .map(value => zio.aws.appsync.model.GraphqlApi.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse
  ): zio.aws.appsync.model.GetGraphqlApiResponse.ReadOnly = new Wrapper(impl)
}
