package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDataSourceResponse(
    dataSource: Option[zio.aws.appsync.model.DataSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetDataSourceResponse = {
    import GetDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetDataSourceResponse
      .builder()
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetDataSourceResponse.ReadOnly =
    zio.aws.appsync.model.GetDataSourceResponse.wrap(buildAwsValue())
}
object GetDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetDataSourceResponse =
      zio.aws.appsync.model
        .GetDataSourceResponse(dataSource.map(value => value.asEditable))
    def dataSource: Option[zio.aws.appsync.model.DataSource.ReadOnly]
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.appsync.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetDataSourceResponse
  ) extends zio.aws.appsync.model.GetDataSourceResponse.ReadOnly {
    override val dataSource: Option[zio.aws.appsync.model.DataSource.ReadOnly] =
      scala
        .Option(impl.dataSource())
        .map(value => zio.aws.appsync.model.DataSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetDataSourceResponse
  ): zio.aws.appsync.model.GetDataSourceResponse.ReadOnly = new Wrapper(impl)
}
