package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateGraphqlApiRequest(
    name: String,
    logConfig: Option[zio.aws.appsync.model.LogConfig] = None,
    authenticationType: zio.aws.appsync.model.AuthenticationType,
    userPoolConfig: Option[zio.aws.appsync.model.UserPoolConfig] = None,
    openIDConnectConfig: Option[zio.aws.appsync.model.OpenIDConnectConfig] =
      None,
    tags: Option[Map[TagKey, TagValue]] = None,
    additionalAuthenticationProviders: Option[
      Iterable[zio.aws.appsync.model.AdditionalAuthenticationProvider]
    ] = None,
    xrayEnabled: Option[Boolean] = None,
    lambdaAuthorizerConfig: Option[
      zio.aws.appsync.model.LambdaAuthorizerConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest = {
    import CreateGraphqlApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .authenticationType(authenticationType.unwrap)
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .optionallyWith(openIDConnectConfig.map(value => value.buildAwsValue()))(
        _.openIDConnectConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthenticationProviders)
      .optionallyWith(xrayEnabled.map(value => value: java.lang.Boolean))(
        _.xrayEnabled
      )
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateGraphqlApiRequest.ReadOnly =
    zio.aws.appsync.model.CreateGraphqlApiRequest.wrap(buildAwsValue())
}
object CreateGraphqlApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateGraphqlApiRequest =
      zio.aws.appsync.model.CreateGraphqlApiRequest(
        name,
        logConfig.map(value => value.asEditable),
        authenticationType,
        userPoolConfig.map(value => value.asEditable),
        openIDConnectConfig.map(value => value.asEditable),
        tags.map(value => value),
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        xrayEnabled.map(value => value),
        lambdaAuthorizerConfig.map(value => value.asEditable)
      )
    def name: String
    def logConfig: Option[zio.aws.appsync.model.LogConfig.ReadOnly]
    def authenticationType: zio.aws.appsync.model.AuthenticationType
    def userPoolConfig: Option[zio.aws.appsync.model.UserPoolConfig.ReadOnly]
    def openIDConnectConfig
        : Option[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def additionalAuthenticationProviders: Option[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ]
    def xrayEnabled: Option[Boolean]
    def lambdaAuthorizerConfig
        : Option[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getLogConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.LogConfig.ReadOnly] =
      AwsError.unwrapOptionField("logConfig", logConfig)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appsync.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
    def getUserPoolConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
    def getOpenIDConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("openIDConnectConfig", openIDConnectConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAdditionalAuthenticationProviders: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalAuthenticationProviders",
      additionalAuthenticationProviders
    )
    def getXrayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("xrayEnabled", xrayEnabled)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest
  ) extends zio.aws.appsync.model.CreateGraphqlApiRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val logConfig: Option[zio.aws.appsync.model.LogConfig.ReadOnly] =
      scala
        .Option(impl.logConfig())
        .map(value => zio.aws.appsync.model.LogConfig.wrap(value))
    override val authenticationType: zio.aws.appsync.model.AuthenticationType =
      zio.aws.appsync.model.AuthenticationType.wrap(impl.authenticationType())
    override val userPoolConfig
        : Option[zio.aws.appsync.model.UserPoolConfig.ReadOnly] = scala
      .Option(impl.userPoolConfig())
      .map(value => zio.aws.appsync.model.UserPoolConfig.wrap(value))
    override val openIDConnectConfig
        : Option[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly] = scala
      .Option(impl.openIDConnectConfig())
      .map(value => zio.aws.appsync.model.OpenIDConnectConfig.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appsync.model.primitives
              .TagKey(key) -> zio.aws.appsync.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val additionalAuthenticationProviders: Option[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ] = scala
      .Option(impl.additionalAuthenticationProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.AdditionalAuthenticationProvider.wrap(item)
        }.toList
      )
    override val xrayEnabled: Option[Boolean] =
      scala.Option(impl.xrayEnabled()).map(value => value: Boolean)
    override val lambdaAuthorizerConfig
        : Option[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly] = scala
      .Option(impl.lambdaAuthorizerConfig())
      .map(value => zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest
  ): zio.aws.appsync.model.CreateGraphqlApiRequest.ReadOnly = new Wrapper(impl)
}
