package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFunctionRequest(apiId: String, functionId: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetFunctionRequest = {
    import GetFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetFunctionRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .functionId(ResourceName.unwrap(functionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetFunctionRequest.ReadOnly =
    zio.aws.appsync.model.GetFunctionRequest.wrap(buildAwsValue())
}
object GetFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetFunctionRequest =
      zio.aws.appsync.model.GetFunctionRequest(apiId, functionId)
    def apiId: String
    def functionId: ResourceName
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getFunctionId: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(functionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetFunctionRequest
  ) extends zio.aws.appsync.model.GetFunctionRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val functionId: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.functionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetFunctionRequest
  ): zio.aws.appsync.model.GetFunctionRequest.ReadOnly = new Wrapper(impl)
}
