package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CachingConfig(
    ttl: Option[Long] = None,
    cachingKeys: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CachingConfig = {
    import CachingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CachingConfig
      .builder()
      .optionallyWith(ttl.map(value => value: java.lang.Long))(_.ttl)
      .optionallyWith(
        cachingKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cachingKeys)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CachingConfig.ReadOnly =
    zio.aws.appsync.model.CachingConfig.wrap(buildAwsValue())
}
object CachingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CachingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CachingConfig = zio.aws.appsync.model
      .CachingConfig(ttl.map(value => value), cachingKeys.map(value => value))
    def ttl: Option[Long]
    def cachingKeys: Option[List[String]]
    def getTtl: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("ttl", ttl)
    def getCachingKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cachingKeys", cachingKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CachingConfig
  ) extends zio.aws.appsync.model.CachingConfig.ReadOnly {
    override val ttl: Option[Long] =
      scala.Option(impl.ttl()).map(value => value: Long)
    override val cachingKeys: Option[List[String]] = scala
      .Option(impl.cachingKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CachingConfig
  ): zio.aws.appsync.model.CachingConfig.ReadOnly = new Wrapper(impl)
}
