package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListGraphqlApisResponse(
    graphqlApis: Option[Iterable[zio.aws.appsync.model.GraphqlApi]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse = {
    import ListGraphqlApisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse
      .builder()
      .optionallyWith(
        graphqlApis.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.graphqlApis)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly =
    zio.aws.appsync.model.ListGraphqlApisResponse.wrap(buildAwsValue())
}
object ListGraphqlApisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListGraphqlApisResponse =
      zio.aws.appsync.model.ListGraphqlApisResponse(
        graphqlApis.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def graphqlApis: Option[List[zio.aws.appsync.model.GraphqlApi.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getGraphqlApis
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.GraphqlApi.ReadOnly]] =
      AwsError.unwrapOptionField("graphqlApis", graphqlApis)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse
  ) extends zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly {
    override val graphqlApis
        : Option[List[zio.aws.appsync.model.GraphqlApi.ReadOnly]] = scala
      .Option(impl.graphqlApis())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.GraphqlApi.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse
  ): zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly = new Wrapper(impl)
}
