package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDataSourceRequest(apiId: String, name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest = {
    import DeleteDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeleteDataSourceRequest.ReadOnly =
    zio.aws.appsync.model.DeleteDataSourceRequest.wrap(buildAwsValue())
}
object DeleteDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeleteDataSourceRequest =
      zio.aws.appsync.model.DeleteDataSourceRequest(apiId, name)
    def apiId: String
    def name: ResourceName
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest
  ) extends zio.aws.appsync.model.DeleteDataSourceRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val name: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest
  ): zio.aws.appsync.model.DeleteDataSourceRequest.ReadOnly = new Wrapper(impl)
}
