package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateApiCacheResponse(
    apiCache: Option[zio.aws.appsync.model.ApiCache] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse = {
    import UpdateApiCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse
      .builder()
      .optionallyWith(apiCache.map(value => value.buildAwsValue()))(_.apiCache)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly =
    zio.aws.appsync.model.UpdateApiCacheResponse.wrap(buildAwsValue())
}
object UpdateApiCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateApiCacheResponse =
      zio.aws.appsync.model
        .UpdateApiCacheResponse(apiCache.map(value => value.asEditable))
    def apiCache: Option[zio.aws.appsync.model.ApiCache.ReadOnly]
    def getApiCache
        : ZIO[Any, AwsError, zio.aws.appsync.model.ApiCache.ReadOnly] =
      AwsError.unwrapOptionField("apiCache", apiCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse
  ) extends zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly {
    override val apiCache: Option[zio.aws.appsync.model.ApiCache.ReadOnly] =
      scala
        .Option(impl.apiCache())
        .map(value => zio.aws.appsync.model.ApiCache.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse
  ): zio.aws.appsync.model.UpdateApiCacheResponse.ReadOnly = new Wrapper(impl)
}
