package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteResolverRequest(
    apiId: String,
    typeName: ResourceName,
    fieldName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeleteResolverRequest = {
    import DeleteResolverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeleteResolverRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .typeName(ResourceName.unwrap(typeName): java.lang.String)
      .fieldName(ResourceName.unwrap(fieldName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeleteResolverRequest.ReadOnly =
    zio.aws.appsync.model.DeleteResolverRequest.wrap(buildAwsValue())
}
object DeleteResolverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeleteResolverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeleteResolverRequest =
      zio.aws.appsync.model.DeleteResolverRequest(apiId, typeName, fieldName)
    def apiId: String
    def typeName: ResourceName
    def fieldName: ResourceName
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTypeName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(typeName)
    def getFieldName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(fieldName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeleteResolverRequest
  ) extends zio.aws.appsync.model.DeleteResolverRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val typeName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.typeName())
    override val fieldName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.fieldName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeleteResolverRequest
  ): zio.aws.appsync.model.DeleteResolverRequest.ReadOnly = new Wrapper(impl)
}
