package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Type(
    name: Option[ResourceName] = None,
    description: Option[String] = None,
    arn: Option[String] = None,
    definition: Option[String] = None,
    format: Option[zio.aws.appsync.model.TypeDefinitionFormat] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.appsync.model.Type = {
    import Type.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.Type
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(definition.map(value => value: java.lang.String))(
        _.definition
      )
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.Type.ReadOnly =
    zio.aws.appsync.model.Type.wrap(buildAwsValue())
}
object Type {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appsync.model.Type] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.Type = zio.aws.appsync.model.Type(
      name.map(value => value),
      description.map(value => value),
      arn.map(value => value),
      definition.map(value => value),
      format.map(value => value)
    )
    def name: Option[ResourceName]
    def description: Option[String]
    def arn: Option[String]
    def definition: Option[String]
    def format: Option[zio.aws.appsync.model.TypeDefinitionFormat]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("definition", definition)
    def getFormat
        : ZIO[Any, AwsError, zio.aws.appsync.model.TypeDefinitionFormat] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.Type
  ) extends zio.aws.appsync.model.Type.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val definition: Option[String] =
      scala.Option(impl.definition()).map(value => value: String)
    override val format: Option[zio.aws.appsync.model.TypeDefinitionFormat] =
      scala
        .Option(impl.format())
        .map(value => zio.aws.appsync.model.TypeDefinitionFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.Type
  ): zio.aws.appsync.model.Type.ReadOnly = new Wrapper(impl)
}
