package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{MappingTemplate, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FunctionConfiguration(
    functionId: Option[String] = None,
    functionArn: Option[String] = None,
    name: Option[ResourceName] = None,
    description: Option[String] = None,
    dataSourceName: Option[ResourceName] = None,
    requestMappingTemplate: Option[MappingTemplate] = None,
    responseMappingTemplate: Option[MappingTemplate] = None,
    functionVersion: Option[String] = None,
    syncConfig: Option[zio.aws.appsync.model.SyncConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.FunctionConfiguration = {
    import FunctionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.FunctionConfiguration
      .builder()
      .optionallyWith(functionId.map(value => value: java.lang.String))(
        _.functionId
      )
      .optionallyWith(functionArn.map(value => value: java.lang.String))(
        _.functionArn
      )
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        dataSourceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.dataSourceName)
      .optionallyWith(
        requestMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.requestMappingTemplate)
      .optionallyWith(
        responseMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.responseMappingTemplate)
      .optionallyWith(functionVersion.map(value => value: java.lang.String))(
        _.functionVersion
      )
      .optionallyWith(syncConfig.map(value => value.buildAwsValue()))(
        _.syncConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.FunctionConfiguration.ReadOnly =
    zio.aws.appsync.model.FunctionConfiguration.wrap(buildAwsValue())
}
object FunctionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.FunctionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.FunctionConfiguration =
      zio.aws.appsync.model.FunctionConfiguration(
        functionId.map(value => value),
        functionArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        dataSourceName.map(value => value),
        requestMappingTemplate.map(value => value),
        responseMappingTemplate.map(value => value),
        functionVersion.map(value => value),
        syncConfig.map(value => value.asEditable)
      )
    def functionId: Option[String]
    def functionArn: Option[String]
    def name: Option[ResourceName]
    def description: Option[String]
    def dataSourceName: Option[ResourceName]
    def requestMappingTemplate: Option[MappingTemplate]
    def responseMappingTemplate: Option[MappingTemplate]
    def functionVersion: Option[String]
    def syncConfig: Option[zio.aws.appsync.model.SyncConfig.ReadOnly]
    def getFunctionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("functionId", functionId)
    def getFunctionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDataSourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("dataSourceName", dataSourceName)
    def getRequestMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "requestMappingTemplate",
        requestMappingTemplate
      )
    def getResponseMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "responseMappingTemplate",
        responseMappingTemplate
      )
    def getFunctionVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getSyncConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.SyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("syncConfig", syncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.FunctionConfiguration
  ) extends zio.aws.appsync.model.FunctionConfiguration.ReadOnly {
    override val functionId: Option[String] =
      scala.Option(impl.functionId()).map(value => value: String)
    override val functionArn: Option[String] =
      scala.Option(impl.functionArn()).map(value => value: String)
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val dataSourceName: Option[ResourceName] = scala
      .Option(impl.dataSourceName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val requestMappingTemplate: Option[MappingTemplate] = scala
      .Option(impl.requestMappingTemplate())
      .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val responseMappingTemplate: Option[MappingTemplate] = scala
      .Option(impl.responseMappingTemplate())
      .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val functionVersion: Option[String] =
      scala.Option(impl.functionVersion()).map(value => value: String)
    override val syncConfig: Option[zio.aws.appsync.model.SyncConfig.ReadOnly] =
      scala
        .Option(impl.syncConfig())
        .map(value => zio.aws.appsync.model.SyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.FunctionConfiguration
  ): zio.aws.appsync.model.FunctionConfiguration.ReadOnly = new Wrapper(impl)
}
