package zio.aws.appsync.model
import java.lang.Integer
import zio.aws.appsync.model.primitives.{MaxResults, PaginationToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFunctionsRequest(
    apiId: String,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListFunctionsRequest = {
    import ListFunctionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListFunctionsRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListFunctionsRequest.ReadOnly =
    zio.aws.appsync.model.ListFunctionsRequest.wrap(buildAwsValue())
}
object ListFunctionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListFunctionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListFunctionsRequest =
      zio.aws.appsync.model.ListFunctionsRequest(
        apiId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def apiId: String
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListFunctionsRequest
  ) extends zio.aws.appsync.model.ListFunctionsRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appsync.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListFunctionsRequest
  ): zio.aws.appsync.model.ListFunctionsRequest.ReadOnly = new Wrapper(impl)
}
