package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataSource(
    dataSourceArn: Option[String] = None,
    name: Option[ResourceName] = None,
    description: Option[String] = None,
    `type`: Option[zio.aws.appsync.model.DataSourceType] = None,
    serviceRoleArn: Option[String] = None,
    dynamodbConfig: Option[zio.aws.appsync.model.DynamodbDataSourceConfig] =
      None,
    lambdaConfig: Option[zio.aws.appsync.model.LambdaDataSourceConfig] = None,
    elasticsearchConfig: Option[
      zio.aws.appsync.model.ElasticsearchDataSourceConfig
    ] = None,
    openSearchServiceConfig: Option[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig
    ] = None,
    httpConfig: Option[zio.aws.appsync.model.HttpDataSourceConfig] = None,
    relationalDatabaseConfig: Option[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DataSource = {
    import DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DataSource
      .builder()
      .optionallyWith(dataSourceArn.map(value => value: java.lang.String))(
        _.dataSourceArn
      )
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(serviceRoleArn.map(value => value: java.lang.String))(
        _.serviceRoleArn
      )
      .optionallyWith(dynamodbConfig.map(value => value.buildAwsValue()))(
        _.dynamodbConfig
      )
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(elasticsearchConfig.map(value => value.buildAwsValue()))(
        _.elasticsearchConfig
      )
      .optionallyWith(
        openSearchServiceConfig.map(value => value.buildAwsValue())
      )(_.openSearchServiceConfig)
      .optionallyWith(httpConfig.map(value => value.buildAwsValue()))(
        _.httpConfig
      )
      .optionallyWith(
        relationalDatabaseConfig.map(value => value.buildAwsValue())
      )(_.relationalDatabaseConfig)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DataSource.ReadOnly =
    zio.aws.appsync.model.DataSource.wrap(buildAwsValue())
}
object DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DataSource =
      zio.aws.appsync.model.DataSource(
        dataSourceArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        serviceRoleArn.map(value => value),
        dynamodbConfig.map(value => value.asEditable),
        lambdaConfig.map(value => value.asEditable),
        elasticsearchConfig.map(value => value.asEditable),
        openSearchServiceConfig.map(value => value.asEditable),
        httpConfig.map(value => value.asEditable),
        relationalDatabaseConfig.map(value => value.asEditable)
      )
    def dataSourceArn: Option[String]
    def name: Option[ResourceName]
    def description: Option[String]
    def `type`: Option[zio.aws.appsync.model.DataSourceType]
    def serviceRoleArn: Option[String]
    def dynamodbConfig
        : Option[zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly]
    def lambdaConfig
        : Option[zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly]
    def elasticsearchConfig
        : Option[zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly]
    def openSearchServiceConfig: Option[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ]
    def httpConfig: Option[zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly]
    def relationalDatabaseConfig: Option[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ]
    def getDataSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataSourceArn", dataSourceArn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, zio.aws.appsync.model.DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getServiceRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getDynamodbConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dynamodbConfig", dynamodbConfig)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getElasticsearchConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("elasticsearchConfig", elasticsearchConfig)
    def getOpenSearchServiceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "openSearchServiceConfig",
      openSearchServiceConfig
    )
    def getHttpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("httpConfig", httpConfig)
    def getRelationalDatabaseConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "relationalDatabaseConfig",
      relationalDatabaseConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DataSource
  ) extends zio.aws.appsync.model.DataSource.ReadOnly {
    override val dataSourceArn: Option[String] =
      scala.Option(impl.dataSourceArn()).map(value => value: String)
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val `type`: Option[zio.aws.appsync.model.DataSourceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.appsync.model.DataSourceType.wrap(value))
    override val serviceRoleArn: Option[String] =
      scala.Option(impl.serviceRoleArn()).map(value => value: String)
    override val dynamodbConfig
        : Option[zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly] =
      scala
        .Option(impl.dynamodbConfig())
        .map(value =>
          zio.aws.appsync.model.DynamodbDataSourceConfig.wrap(value)
        )
    override val lambdaConfig
        : Option[zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly] = scala
      .Option(impl.lambdaConfig())
      .map(value => zio.aws.appsync.model.LambdaDataSourceConfig.wrap(value))
    override val elasticsearchConfig
        : Option[zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly] =
      scala
        .Option(impl.elasticsearchConfig())
        .map(value =>
          zio.aws.appsync.model.ElasticsearchDataSourceConfig.wrap(value)
        )
    override val openSearchServiceConfig: Option[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ] = scala
      .Option(impl.openSearchServiceConfig())
      .map(value =>
        zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.wrap(value)
      )
    override val httpConfig
        : Option[zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly] = scala
      .Option(impl.httpConfig())
      .map(value => zio.aws.appsync.model.HttpDataSourceConfig.wrap(value))
    override val relationalDatabaseConfig: Option[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ] = scala
      .Option(impl.relationalDatabaseConfig())
      .map(value =>
        zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DataSource
  ): zio.aws.appsync.model.DataSource.ReadOnly = new Wrapper(impl)
}
