package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTypesResponse(
    types: Option[Iterable[zio.aws.appsync.model.Type]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListTypesResponse = {
    import ListTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListTypesResponse
      .builder()
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListTypesResponse.ReadOnly =
    zio.aws.appsync.model.ListTypesResponse.wrap(buildAwsValue())
}
object ListTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListTypesResponse =
      zio.aws.appsync.model.ListTypesResponse(
        types.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def types: Option[List[zio.aws.appsync.model.Type.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getTypes
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.Type.ReadOnly]] =
      AwsError.unwrapOptionField("types", types)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListTypesResponse
  ) extends zio.aws.appsync.model.ListTypesResponse.ReadOnly {
    override val types: Option[List[zio.aws.appsync.model.Type.ReadOnly]] =
      scala
        .Option(impl.types())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appsync.model.Type.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListTypesResponse
  ): zio.aws.appsync.model.ListTypesResponse.ReadOnly = new Wrapper(impl)
}
