package zio.aws.appsync.model
import java.lang.Integer
import zio.aws.appsync.model.primitives.{MaxResults, PaginationToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListResolversByFunctionRequest(
    apiId: String,
    functionId: String,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest = {
    import ListResolversByFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .functionId(functionId: java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.ListResolversByFunctionRequest.ReadOnly =
    zio.aws.appsync.model.ListResolversByFunctionRequest.wrap(buildAwsValue())
}
object ListResolversByFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListResolversByFunctionRequest =
      zio.aws.appsync.model.ListResolversByFunctionRequest(
        apiId,
        functionId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def apiId: String
    def functionId: String
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getFunctionId: ZIO[Any, Nothing, String] = ZIO.succeed(functionId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest
  ) extends zio.aws.appsync.model.ListResolversByFunctionRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val functionId: String = impl.functionId(): String
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appsync.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest
  ): zio.aws.appsync.model.ListResolversByFunctionRequest.ReadOnly =
    new Wrapper(impl)
}
