package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{Description, DomainName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDomainNameRequest(
    domainName: DomainName,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest = {
    import UpdateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateDomainNameRequest.ReadOnly =
    zio.aws.appsync.model.UpdateDomainNameRequest.wrap(buildAwsValue())
}
object UpdateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateDomainNameRequest =
      zio.aws.appsync.model
        .UpdateDomainNameRequest(domainName, description.map(value => value))
    def domainName: DomainName
    def description: Optional[Description]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest
  ) extends zio.aws.appsync.model.UpdateDomainNameRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.appsync.model.primitives.DomainName(impl.domainName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appsync.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest
  ): zio.aws.appsync.model.UpdateDomainNameRequest.ReadOnly = new Wrapper(impl)
}
