package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait Ownership {
  def unwrap: software.amazon.awssdk.services.appsync.model.Ownership
}
object Ownership {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.Ownership
  ): zio.aws.appsync.model.Ownership = value match {
    case software.amazon.awssdk.services.appsync.model.Ownership.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.Ownership.CURRENT_ACCOUNT =>
      val r = CURRENT_ACCOUNT
      r
    case software.amazon.awssdk.services.appsync.model.Ownership.OTHER_ACCOUNTS =>
      val r = OTHER_ACCOUNTS
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.Ownership {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.Ownership =
      software.amazon.awssdk.services.appsync.model.Ownership.UNKNOWN_TO_SDK_VERSION
  }
  case object CURRENT_ACCOUNT extends zio.aws.appsync.model.Ownership {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.Ownership =
      software.amazon.awssdk.services.appsync.model.Ownership.CURRENT_ACCOUNT
  }
  case object OTHER_ACCOUNTS extends zio.aws.appsync.model.Ownership {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.Ownership =
      software.amazon.awssdk.services.appsync.model.Ownership.OTHER_ACCOUNTS
  }
}
