package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait GraphQLApiType {
  def unwrap: software.amazon.awssdk.services.appsync.model.GraphQLApiType
}
object GraphQLApiType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.GraphQLApiType
  ): zio.aws.appsync.model.GraphQLApiType = value match {
    case software.amazon.awssdk.services.appsync.model.GraphQLApiType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.GraphQLApiType.GRAPHQL =>
      val r = GRAPHQL
      r
    case software.amazon.awssdk.services.appsync.model.GraphQLApiType.MERGED =>
      val r = MERGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.GraphQLApiType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.GraphQLApiType =
      software.amazon.awssdk.services.appsync.model.GraphQLApiType.UNKNOWN_TO_SDK_VERSION
  }
  case object GRAPHQL extends zio.aws.appsync.model.GraphQLApiType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.GraphQLApiType =
      software.amazon.awssdk.services.appsync.model.GraphQLApiType.GRAPHQL
  }
  case object MERGED extends zio.aws.appsync.model.GraphQLApiType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.GraphQLApiType =
      software.amazon.awssdk.services.appsync.model.GraphQLApiType.MERGED
  }
}
