package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartSchemaMergeRequest(
    associationId: String,
    mergedApiIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest = {
    import StartSchemaMergeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest
      .builder()
      .associationId(associationId: java.lang.String)
      .mergedApiIdentifier(mergedApiIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.StartSchemaMergeRequest.ReadOnly =
    zio.aws.appsync.model.StartSchemaMergeRequest.wrap(buildAwsValue())
}
object StartSchemaMergeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.StartSchemaMergeRequest =
      zio.aws.appsync.model
        .StartSchemaMergeRequest(associationId, mergedApiIdentifier)
    def associationId: String
    def mergedApiIdentifier: String
    def getAssociationId: ZIO[Any, Nothing, String] = ZIO.succeed(associationId)
    def getMergedApiIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(mergedApiIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest
  ) extends zio.aws.appsync.model.StartSchemaMergeRequest.ReadOnly {
    override val associationId: String = impl.associationId(): String
    override val mergedApiIdentifier: String =
      impl.mergedApiIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest
  ): zio.aws.appsync.model.StartSchemaMergeRequest.ReadOnly = new Wrapper(impl)
}
