package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSourceApiAssociationRequest(
    associationId: String,
    mergedApiIdentifier: String,
    description: Optional[String] = Optional.Absent,
    sourceApiAssociationConfig: Optional[
      zio.aws.appsync.model.SourceApiAssociationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest = {
    import UpdateSourceApiAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest
      .builder()
      .associationId(associationId: java.lang.String)
      .mergedApiIdentifier(mergedApiIdentifier: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        sourceApiAssociationConfig.map(value => value.buildAwsValue())
      )(_.sourceApiAssociationConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.UpdateSourceApiAssociationRequest.ReadOnly =
    zio.aws.appsync.model.UpdateSourceApiAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateSourceApiAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateSourceApiAssociationRequest =
      zio.aws.appsync.model.UpdateSourceApiAssociationRequest(
        associationId,
        mergedApiIdentifier,
        description.map(value => value),
        sourceApiAssociationConfig.map(value => value.asEditable)
      )
    def associationId: String
    def mergedApiIdentifier: String
    def description: Optional[String]
    def sourceApiAssociationConfig
        : Optional[zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly]
    def getAssociationId: ZIO[Any, Nothing, String] = ZIO.succeed(associationId)
    def getMergedApiIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(mergedApiIdentifier)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSourceApiAssociationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceApiAssociationConfig",
      sourceApiAssociationConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest
  ) extends zio.aws.appsync.model.UpdateSourceApiAssociationRequest.ReadOnly {
    override val associationId: String = impl.associationId(): String
    override val mergedApiIdentifier: String =
      impl.mergedApiIdentifier(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val sourceApiAssociationConfig
        : Optional[zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociationConfig())
        .map(value =>
          zio.aws.appsync.model.SourceApiAssociationConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest
  ): zio.aws.appsync.model.UpdateSourceApiAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
