package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait RuntimeName {
  def unwrap: software.amazon.awssdk.services.appsync.model.RuntimeName
}
object RuntimeName {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.RuntimeName
  ): zio.aws.appsync.model.RuntimeName = value match {
    case software.amazon.awssdk.services.appsync.model.RuntimeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.RuntimeName.APPSYNC_JS =>
      val r = APPSYNC_JS
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.RuntimeName {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.RuntimeName =
      software.amazon.awssdk.services.appsync.model.RuntimeName.UNKNOWN_TO_SDK_VERSION
  }
  case object APPSYNC_JS extends zio.aws.appsync.model.RuntimeName {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.RuntimeName =
      software.amazon.awssdk.services.appsync.model.RuntimeName.APPSYNC_JS
  }
}
