package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamConfig(
    signingRegion: Optional[String] = Optional.Absent,
    signingServiceName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AwsIamConfig = {
    import AwsIamConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AwsIamConfig
      .builder()
      .optionallyWith(signingRegion.map(value => value: java.lang.String))(
        _.signingRegion
      )
      .optionallyWith(signingServiceName.map(value => value: java.lang.String))(
        _.signingServiceName
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.AwsIamConfig.ReadOnly =
    zio.aws.appsync.model.AwsIamConfig.wrap(buildAwsValue())
}
object AwsIamConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AwsIamConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AwsIamConfig =
      zio.aws.appsync.model.AwsIamConfig(
        signingRegion.map(value => value),
        signingServiceName.map(value => value)
      )
    def signingRegion: Optional[String]
    def signingServiceName: Optional[String]
    def getSigningRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signingRegion", signingRegion)
    def getSigningServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signingServiceName", signingServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AwsIamConfig
  ) extends zio.aws.appsync.model.AwsIamConfig.ReadOnly {
    override val signingRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signingRegion())
      .map(value => value: String)
    override val signingServiceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.signingServiceName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AwsIamConfig
  ): zio.aws.appsync.model.AwsIamConfig.ReadOnly = new Wrapper(impl)
}
