package zio.aws.appsync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.Date
import scala.jdk.CollectionConverters._
final case class SourceApiAssociation(
    associationId: Optional[String] = Optional.Absent,
    associationArn: Optional[String] = Optional.Absent,
    sourceApiId: Optional[String] = Optional.Absent,
    sourceApiArn: Optional[String] = Optional.Absent,
    mergedApiArn: Optional[String] = Optional.Absent,
    mergedApiId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    sourceApiAssociationConfig: Optional[
      zio.aws.appsync.model.SourceApiAssociationConfig
    ] = Optional.Absent,
    sourceApiAssociationStatus: Optional[
      zio.aws.appsync.model.SourceApiAssociationStatus
    ] = Optional.Absent,
    sourceApiAssociationStatusDetail: Optional[String] = Optional.Absent,
    lastSuccessfulMergeDate: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.SourceApiAssociation = {
    import SourceApiAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.SourceApiAssociation
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(associationArn.map(value => value: java.lang.String))(
        _.associationArn
      )
      .optionallyWith(sourceApiId.map(value => value: java.lang.String))(
        _.sourceApiId
      )
      .optionallyWith(sourceApiArn.map(value => value: java.lang.String))(
        _.sourceApiArn
      )
      .optionallyWith(mergedApiArn.map(value => value: java.lang.String))(
        _.mergedApiArn
      )
      .optionallyWith(mergedApiId.map(value => value: java.lang.String))(
        _.mergedApiId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        sourceApiAssociationConfig.map(value => value.buildAwsValue())
      )(_.sourceApiAssociationConfig)
      .optionallyWith(sourceApiAssociationStatus.map(value => value.unwrap))(
        _.sourceApiAssociationStatus
      )
      .optionallyWith(
        sourceApiAssociationStatusDetail.map(value => value: java.lang.String)
      )(_.sourceApiAssociationStatusDetail)
      .optionallyWith(
        lastSuccessfulMergeDate.map(value => Date.unwrap(value): Instant)
      )(_.lastSuccessfulMergeDate)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.SourceApiAssociation.ReadOnly =
    zio.aws.appsync.model.SourceApiAssociation.wrap(buildAwsValue())
}
object SourceApiAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.SourceApiAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.SourceApiAssociation =
      zio.aws.appsync.model.SourceApiAssociation(
        associationId.map(value => value),
        associationArn.map(value => value),
        sourceApiId.map(value => value),
        sourceApiArn.map(value => value),
        mergedApiArn.map(value => value),
        mergedApiId.map(value => value),
        description.map(value => value),
        sourceApiAssociationConfig.map(value => value.asEditable),
        sourceApiAssociationStatus.map(value => value),
        sourceApiAssociationStatusDetail.map(value => value),
        lastSuccessfulMergeDate.map(value => value)
      )
    def associationId: Optional[String]
    def associationArn: Optional[String]
    def sourceApiId: Optional[String]
    def sourceApiArn: Optional[String]
    def mergedApiArn: Optional[String]
    def mergedApiId: Optional[String]
    def description: Optional[String]
    def sourceApiAssociationConfig
        : Optional[zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly]
    def sourceApiAssociationStatus
        : Optional[zio.aws.appsync.model.SourceApiAssociationStatus]
    def sourceApiAssociationStatusDetail: Optional[String]
    def lastSuccessfulMergeDate: Optional[Date]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationArn", associationArn)
    def getSourceApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceApiId", sourceApiId)
    def getSourceApiArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceApiArn", sourceApiArn)
    def getMergedApiArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mergedApiArn", mergedApiArn)
    def getMergedApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mergedApiId", mergedApiId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSourceApiAssociationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceApiAssociationConfig",
      sourceApiAssociationConfig
    )
    def getSourceApiAssociationStatus
        : ZIO[Any, AwsError, zio.aws.appsync.model.SourceApiAssociationStatus] =
      AwsError.unwrapOptionField(
        "sourceApiAssociationStatus",
        sourceApiAssociationStatus
      )
    def getSourceApiAssociationStatusDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceApiAssociationStatusDetail",
        sourceApiAssociationStatusDetail
      )
    def getLastSuccessfulMergeDate: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("lastSuccessfulMergeDate", lastSuccessfulMergeDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.SourceApiAssociation
  ) extends zio.aws.appsync.model.SourceApiAssociation.ReadOnly {
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val associationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationArn())
      .map(value => value: String)
    override val sourceApiId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceApiId())
      .map(value => value: String)
    override val sourceApiArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceApiArn())
      .map(value => value: String)
    override val mergedApiArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mergedApiArn())
      .map(value => value: String)
    override val mergedApiId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mergedApiId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val sourceApiAssociationConfig
        : Optional[zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociationConfig())
        .map(value =>
          zio.aws.appsync.model.SourceApiAssociationConfig.wrap(value)
        )
    override val sourceApiAssociationStatus
        : Optional[zio.aws.appsync.model.SourceApiAssociationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociationStatus())
        .map(value =>
          zio.aws.appsync.model.SourceApiAssociationStatus.wrap(value)
        )
    override val sourceApiAssociationStatusDetail: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociationStatusDetail())
        .map(value => value: String)
    override val lastSuccessfulMergeDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSuccessfulMergeDate())
      .map(value => zio.aws.appsync.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.SourceApiAssociation
  ): zio.aws.appsync.model.SourceApiAssociation.ReadOnly = new Wrapper(impl)
}
