package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait MergeType {
  def unwrap: software.amazon.awssdk.services.appsync.model.MergeType
}
object MergeType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.MergeType
  ): zio.aws.appsync.model.MergeType = value match {
    case software.amazon.awssdk.services.appsync.model.MergeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.MergeType.MANUAL_MERGE =>
      val r = MANUAL_MERGE
      r
    case software.amazon.awssdk.services.appsync.model.MergeType.AUTO_MERGE =>
      val r = AUTO_MERGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.MergeType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.MergeType =
      software.amazon.awssdk.services.appsync.model.MergeType.UNKNOWN_TO_SDK_VERSION
  }
  case object MANUAL_MERGE extends zio.aws.appsync.model.MergeType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.MergeType =
      software.amazon.awssdk.services.appsync.model.MergeType.MANUAL_MERGE
  }
  case object AUTO_MERGE extends zio.aws.appsync.model.MergeType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.MergeType =
      software.amazon.awssdk.services.appsync.model.MergeType.AUTO_MERGE
  }
}
